"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usersReducer = exports.initialUsersState = void 0;
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _fp = require("@kbn/safer-lodash-set/fp");
var _constants = require("../../../common/store/constants");
var _actions = require("./actions");
var _helpers = require("./helpers");
var _model = require("./model");
var _common = require("../../../../common/search_strategy/common");
var _search_strategy = require("../../../../common/search_strategy");
var _common2 = require("../../../../common/search_strategy/security_solution/users/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialUsersState = {
  page: {
    queries: {
      [_model.UsersTableType.allUsers]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _common2.UsersFields.lastSeen,
          direction: _common.Direction.desc
        }
      },
      [_model.UsersTableType.authentications]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT
      },
      [_model.UsersTableType.risk]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT,
        sort: {
          field: _search_strategy.RiskScoreFields.userRiskScore,
          direction: _common.Direction.desc
        },
        severitySelection: []
      },
      [_model.UsersTableType.anomalies]: {
        jobIdSelection: [],
        intervalSelection: 'auto'
      },
      [_model.UsersTableType.events]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT
      }
    }
  },
  details: {
    queries: {
      [_model.UsersTableType.anomalies]: {
        jobIdSelection: [],
        intervalSelection: 'auto'
      },
      [_model.UsersTableType.events]: {
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
        limit: _constants.DEFAULT_TABLE_LIMIT
      }
    }
  }
};
exports.initialUsersState = initialUsersState;
const usersReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(initialUsersState).case(_actions.setUsersTablesActivePageToZero, state => ({
  ...state,
  page: {
    ...state.page,
    queries: (0, _helpers.setUsersPageQueriesActivePageToZero)(state)
  }
})).case(_actions.updateTableActivePage, (state, {
  activePage,
  tableType
}) => ({
  ...state,
  page: {
    ...state.page,
    queries: {
      ...state.page.queries,
      [tableType]: {
        ...state.page.queries[tableType],
        activePage
      }
    }
  }
})).case(_actions.updateTableLimit, (state, {
  limit,
  tableType
}) => ({
  ...state,
  page: {
    ...state.page,
    queries: {
      ...state.page.queries,
      [tableType]: {
        ...state.page.queries[tableType],
        limit
      }
    }
  }
})).case(_actions.updateTableSorting, (state, {
  sort,
  tableType
}) => ({
  ...state,
  page: {
    ...state.page,
    queries: {
      ...state.page.queries,
      [tableType]: {
        ...state.page.queries[tableType],
        sort,
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
      }
    }
  }
})).case(_actions.updateUserRiskScoreSeverityFilter, (state, {
  severitySelection
}) => ({
  ...state,
  page: {
    ...state.page,
    queries: {
      ...state.page.queries,
      [_model.UsersTableType.risk]: {
        ...state.page.queries[_model.UsersTableType.risk],
        severitySelection,
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
      }
    }
  }
})).case(_actions.updateUsersAnomaliesJobIdFilter, (state, {
  jobIds,
  usersType
}) => {
  if (usersType === 'page') {
    return (0, _fp.set)('page.queries.anomalies.jobIdSelection', jobIds, state);
  } else {
    return (0, _fp.set)('details.queries.anomalies.jobIdSelection', jobIds, state);
  }
}).case(_actions.updateUsersAnomaliesInterval, (state, {
  interval,
  usersType
}) => {
  if (usersType === 'page') {
    return (0, _fp.set)('page.queries.anomalies.intervalSelection', interval, state);
  } else {
    return (0, _fp.set)('details.queries.anomalies.intervalSelection', interval, state);
  }
}).build();
exports.usersReducer = usersReducer;