"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.type = exports.getTrailingBreadcrumbs = void 0;
var _fp = require("lodash/fp");
var _helpers = require("../../../../common/lib/helpers");
var _redirect_to_network = require("../../../../common/components/link_to/redirect_to_network");
var _store = require("../../store");
var i18n = _interopRequireWildcard(require("../translations"));
var _types = require("./types");
var _types2 = require("../../../../app/types");
var _types3 = require("../navigation/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const type = _store.networkModel.NetworkType.details;
exports.type = type;
const TabNameMappedToI18nKey = {
  [_types.NetworkDetailsRouteType.events]: i18n.NAVIGATION_EVENTS_TITLE,
  [_types.NetworkDetailsRouteType.anomalies]: i18n.NAVIGATION_ANOMALIES_TITLE,
  [_types.NetworkDetailsRouteType.flows]: i18n.NAVIGATION_FLOWS_TITLE,
  [_types.NetworkDetailsRouteType.users]: i18n.NAVIGATION_USERS_TITLE,
  [_types.NetworkDetailsRouteType.http]: i18n.NAVIGATION_HTTP_TITLE,
  [_types.NetworkDetailsRouteType.tls]: i18n.NAVIGATION_TLS_TITLE,
  [_types3.NetworkRouteType.dns]: i18n.NAVIGATION_DNS_TITLE
};
const getTrailingBreadcrumbs = (params, getSecuritySolutionUrl) => {
  let breadcrumb = [];
  if (params.detailName != null) {
    breadcrumb = [{
      text: (0, _helpers.decodeIpv6)(params.detailName),
      href: getSecuritySolutionUrl({
        deepLinkId: _types2.SecurityPageName.network,
        path: (0, _redirect_to_network.getNetworkDetailsUrl)(params.detailName, params.flowTarget, '')
      })
    }];
  }
  const tabName = (0, _fp.get)('tabName', params);
  if (!tabName) return breadcrumb;
  breadcrumb = [...breadcrumb, {
    text: TabNameMappedToI18nKey[tabName],
    href: ''
  }];
  return breadcrumb;
};
exports.getTrailingBreadcrumbs = getTrailingBreadcrumbs;