"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RISKY_HOSTS_TITLE = exports.RISKY_HOSTS_DESCRIPTION = exports.INSPECT_RISKY_HOSTS = exports.HOSTS_COUNT = exports.ERROR_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOSTS_COUNT = quantity => _i18n.i18n.translate('xpack.securitySolution.kpiHosts.riskyHosts.hostsCount', {
  defaultMessage: '{quantity} {quantity, plural, =1 {host} other {hosts}}',
  values: {
    quantity
  }
});
exports.HOSTS_COUNT = HOSTS_COUNT;
const RISKY_HOSTS_DESCRIPTION = (quantity, formattedQuantity) => _i18n.i18n.translate('xpack.securitySolution.kpiHosts.riskyHosts.description', {
  defaultMessage: '{formattedQuantity} Risky {quantity, plural, =1 {Host} other {Hosts}}',
  values: {
    formattedQuantity,
    quantity
  }
});
exports.RISKY_HOSTS_DESCRIPTION = RISKY_HOSTS_DESCRIPTION;
const RISKY_HOSTS_TITLE = _i18n.i18n.translate('xpack.securitySolution.kpiHosts.riskyHosts.title', {
  defaultMessage: 'Risky Hosts'
});
exports.RISKY_HOSTS_TITLE = RISKY_HOSTS_TITLE;
const INSPECT_RISKY_HOSTS = _i18n.i18n.translate('xpack.securitySolution.kpiHosts.riskyHosts.inspectTitle', {
  defaultMessage: 'Risky Hosts'
});
exports.INSPECT_RISKY_HOSTS = INSPECT_RISKY_HOSTS;
const ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.kpiHosts.riskyHosts.errorMessage', {
  defaultMessage: 'Error Fetching Risky Hosts API'
});
exports.ERROR_TITLE = ERROR_TITLE;