"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KpiBaseComponentManage = exports.KpiBaseComponent = exports.FlexGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _manage_query = require("../../../../../common/components/page/manage_query");
var _stat_items = require("../../../../components/stat_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const kpiWidgetHeight = 247;
const FlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  min-height: ${kpiWidgetHeight}px;
`;
exports.FlexGroup = FlexGroup;
FlexGroup.displayName = 'FlexGroup';
const KpiBaseComponent = /*#__PURE__*/_react.default.memo(({
  fieldsMapping,
  data,
  id,
  loading = false,
  from,
  to,
  updateDateRange,
  setQuerySkip
}) => {
  const statItemsProps = (0, _stat_items.useKpiMatrixStatus)(fieldsMapping, data, id, from, to, updateDateRange, setQuerySkip, loading);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true
  }, statItemsProps.map(mappedStatItemProps => /*#__PURE__*/_react.default.createElement(_stat_items.StatItemsComponent, mappedStatItemProps)));
}, (prevProps, nextProps) => prevProps.fieldsMapping === nextProps.fieldsMapping && prevProps.id === nextProps.id && prevProps.loading === nextProps.loading && prevProps.from === nextProps.from && prevProps.to === nextProps.to && prevProps.updateDateRange === nextProps.updateDateRange && (0, _fastDeepEqual.default)(prevProps.data, nextProps.data));
exports.KpiBaseComponent = KpiBaseComponent;
KpiBaseComponent.displayName = 'KpiBaseComponent';
const KpiBaseComponentManage = (0, _manage_query.manageQuery)(KpiBaseComponent);
exports.KpiBaseComponentManage = KpiBaseComponentManage;