"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION = exports.UNIT = exports.ROWS_5 = exports.ROWS_10 = exports.RISK_SCORE = exports.OS_LAST_SEEN_TOOLTIP = exports.OS = exports.NAME = exports.LAST_SEEN = exports.HOST_RISK_TOOLTIP = exports.HOSTS = exports.FIRST_LAST_SEEN_TOOLTIP = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOSTS = _i18n.i18n.translate('xpack.securitySolution.hostsTable.hostsTitle', {
  defaultMessage: 'All hosts'
});
exports.HOSTS = HOSTS;
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.hostsTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {host} other {hosts}}`
});
exports.UNIT = UNIT;
const RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.tableTitle', {
  defaultMessage: 'Host risk'
});
exports.RISK_SCORE = RISK_SCORE;
const NAME = _i18n.i18n.translate('xpack.securitySolution.hostsTable.nameTitle', {
  defaultMessage: 'Host name'
});
exports.NAME = NAME;
const LAST_SEEN = _i18n.i18n.translate('xpack.securitySolution.hostsTable.lastSeenTitle', {
  defaultMessage: 'Last seen'
});
exports.LAST_SEEN = LAST_SEEN;
const FIRST_LAST_SEEN_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.hostsTable.firstLastSeenToolTip', {
  defaultMessage: 'Relative to the selected date range'
});
exports.FIRST_LAST_SEEN_TOOLTIP = FIRST_LAST_SEEN_TOOLTIP;
const HOST_RISK_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.hostsTable.hostRiskToolTip', {
  defaultMessage: 'Host risk classification is determined by host risk score. Hosts classified as Critical or High are indicated as risky.'
});
exports.HOST_RISK_TOOLTIP = HOST_RISK_TOOLTIP;
const OS_LAST_SEEN_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.hostsTable.osLastSeenToolTip', {
  defaultMessage: 'Last observed operating system'
});
exports.OS_LAST_SEEN_TOOLTIP = OS_LAST_SEEN_TOOLTIP;
const OS = _i18n.i18n.translate('xpack.securitySolution.hostsTable.osTitle', {
  defaultMessage: 'Operating system'
});
exports.OS = OS;
const VERSION = _i18n.i18n.translate('xpack.securitySolution.hostsTable.versionTitle', {
  defaultMessage: 'Version'
});
exports.VERSION = VERSION;
const ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.hostsTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_5 = ROWS_5;
const ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.hostsTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_10 = ROWS_10;