"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskScoreFeatureStatus = void 0;
var _react = require("react");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _use_fetch = require("../../../../common/hooks/use_fetch");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRiskScoreFeatureStatus = (riskEntity, defaultIndex) => {
  const {
    isPlatinumOrTrialLicense,
    capabilitiesFetched
  } = (0, _use_ml_capabilities.useMlCapabilities)();
  const {
    fetch,
    data,
    isLoading,
    error
  } = (0, _use_fetch.useFetch)(_use_fetch.REQUEST_NAMES.GET_RISK_SCORE_DEPRECATED, _api.getRiskScoreIndexStatus);
  const response = (0, _react.useMemo)(
  // if license is enabled, let isDeprecated = true so the actual
  // risk score fetch is not called until this check is complete
  () => data ? data : {
    isDeprecated: isPlatinumOrTrialLicense,
    isEnabled: isPlatinumOrTrialLicense
  },
  // isPlatinumOrTrialLicense is initial state, not update requirement
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [data]);
  const searchIndexStatus = (0, _react.useCallback)(indexName => {
    fetch({
      query: {
        indexName,
        entity: riskEntity
      }
    });
  }, [riskEntity, fetch]);
  (0, _react.useEffect)(() => {
    if (isPlatinumOrTrialLicense && defaultIndex != null) {
      searchIndexStatus(defaultIndex);
    }
  }, [isPlatinumOrTrialLicense, defaultIndex, searchIndexStatus]);
  return {
    error,
    isLoading: isLoading || !capabilitiesFetched || defaultIndex == null,
    refetch: searchIndexStatus,
    isLicenseValid: isPlatinumOrTrialLicense,
    ...response
  };
};
exports.useRiskScoreFeatureStatus = useRiskScoreFeatureStatus;