"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAuthentications = void 0;
var _react = require("react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _security_solution = require("../../../../common/search_strategy/security_solution");
var _helpers = require("../../../common/containers/helpers");
var _helpers2 = require("../../components/paginated_table/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_search_strategy = require("../../../common/containers/use_search_strategy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAuthentications = ({
  activePage,
  endDate,
  filterQuery,
  indexNames,
  limit,
  skip,
  stackByField,
  startDate
}) => {
  const [authenticationsRequest, setAuthenticationsRequest] = (0, _react.useState)(null);
  const wrappedLoadMore = (0, _react.useCallback)(newActivePage => {
    setAuthenticationsRequest(prevRequest => {
      if (!prevRequest) {
        return prevRequest;
      }
      return {
        ...prevRequest,
        pagination: (0, _helpers2.generateTablePaginationOptions)(newActivePage, limit)
      };
    });
  }, [limit]);
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _security_solution.UsersQueries.authentications,
    initialResult: {
      edges: [],
      totalCount: -1,
      pageInfo: {
        activePage: 0,
        fakeTotalCount: 0,
        showMorePagesIndicator: false
      }
    },
    errorMessage: i18n.FAIL_AUTHENTICATIONS,
    abort: skip
  });
  const authenticationsResponse = (0, _react.useMemo)(() => ({
    endDate,
    authentications: response.edges,
    inspect,
    isInspected: false,
    loadPage: wrappedLoadMore,
    pageInfo: response.pageInfo,
    refetch,
    startDate,
    totalCount: response.totalCount
  }), [endDate, inspect, refetch, response.edges, response.pageInfo, response.totalCount, startDate, wrappedLoadMore]);
  (0, _react.useEffect)(() => {
    setAuthenticationsRequest(prevRequest => {
      const myRequest = {
        ...(prevRequest !== null && prevRequest !== void 0 ? prevRequest : {}),
        defaultIndex: indexNames,
        factoryQueryType: _security_solution.UsersQueries.authentications,
        filterQuery: (0, _helpers.createFilter)(filterQuery),
        stackByField,
        pagination: (0, _helpers2.generateTablePaginationOptions)(activePage, limit),
        timerange: {
          interval: '12h',
          from: startDate,
          to: endDate
        },
        sort: {}
      };
      if (!(0, _fastDeepEqual.default)(prevRequest, myRequest)) {
        return myRequest;
      }
      return prevRequest;
    });
  }, [activePage, endDate, filterQuery, indexNames, stackByField, limit, startDate]);
  (0, _react.useEffect)(() => {
    if (!skip && authenticationsRequest) {
      search(authenticationsRequest);
    }
  }, [authenticationsRequest, search, skip]);
  return [loading, authenticationsResponse];
};
exports.useAuthentications = useAuthentications;