"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatItemsComponent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _areachart = require("../../../common/components/charts/areachart");
var _barchart = require("../../../common/components/charts/barchart");
var _utils = require("../../../common/components/utils");
var _stat_item_header = require("./stat_item_header");
var _use_toggle_status = require("./use_toggle_status");
var _utils2 = require("./utils");
var _metric = require("./metric");
var _metric_embeddable = require("./metric_embeddable");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatItemsComponent = /*#__PURE__*/_react.default.memo(({
  areaChart,
  barChart,
  description,
  enableAreaChart,
  enableBarChart,
  fields,
  from,
  grow,
  id,
  loading = false,
  index,
  updateDateRange,
  statKey = 'item',
  to,
  barChartLensAttributes,
  areaChartLensAttributes,
  setQuerySkip
}) => {
  const isBarChartDataAvailable = !!(barChart && barChart.length && barChart.every(item => item.value != null && item.value.length > 0));
  const isAreaChartDataAvailable = !!(areaChart && areaChart.length && areaChart.every(item => item.value != null && item.value.length > 0));
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const {
    isToggleExpanded,
    onToggle
  } = (0, _use_toggle_status.useToggleStatus)({
    id,
    setQuerySkip
  });
  const isChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('chartEmbeddablesEnabled');
  return /*#__PURE__*/_react.default.createElement(_utils2.FlexItem, {
    grow: grow,
    "data-test-subj": `stat-${statKey}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_stat_item_header.StatItemHeader, {
    onToggle: onToggle,
    isToggleExpanded: isToggleExpanded,
    description: description
  }), loading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": "loading-spinner"
  }))), isToggleExpanded && !loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isChartEmbeddablesEnabled ? /*#__PURE__*/_react.default.createElement(_metric_embeddable.MetricEmbeddable, {
    fields: fields,
    id: id,
    timerange: timerange,
    inspectTitle: description
  }) : /*#__PURE__*/_react.default.createElement(_metric.Metric, {
    fields: fields,
    id: id,
    timerange: timerange,
    isAreaChartDataAvailable: isAreaChartDataAvailable,
    isBarChartDataAvailable: isBarChartDataAvailable,
    inspectTitle: description,
    inspectIndex: index
  }), (enableAreaChart || enableBarChart) && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: isChartEmbeddablesEnabled ? 'none' : 'l'
  }, enableBarChart && /*#__PURE__*/_react.default.createElement(_utils2.FlexItem, null, isChartEmbeddablesEnabled && barChartLensAttributes ? /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-bar-chart",
    lensAttributes: barChartLensAttributes,
    timerange: timerange,
    id: `${id}-bar-embeddable`,
    height: _utils2.ChartHeight,
    inspectTitle: description
  }) : /*#__PURE__*/_react.default.createElement(_barchart.BarChart, {
    barChart: barChart,
    configs: (0, _utils2.barchartConfigs)(),
    visualizationActionsOptions: {
      lensAttributes: barChartLensAttributes,
      queryId: id,
      inspectIndex: index,
      timerange,
      title: description
    }
  })), enableAreaChart && from != null && to != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_utils2.FlexItem, null, isChartEmbeddablesEnabled && areaChartLensAttributes ? /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-area-chart",
    lensAttributes: areaChartLensAttributes,
    timerange: timerange,
    id: `${id}-area-embeddable`,
    height: _utils2.ChartHeight,
    inspectTitle: description
  }) : /*#__PURE__*/_react.default.createElement(_areachart.AreaChart, {
    areaChart: areaChart,
    configs: (0, _utils2.areachartConfigs)({
      xTickFormatter: (0, _utils.histogramDateTimeFormatter)([from, to]),
      onBrushEnd: updateDateRange
    }),
    visualizationActionsOptions: {
      lensAttributes: areaChartLensAttributes,
      queryId: id,
      inspectIndex: index,
      timerange,
      title: description
    }
  })))))));
}, (prevProps, nextProps) => prevProps.description === nextProps.description && prevProps.enableAreaChart === nextProps.enableAreaChart && prevProps.enableBarChart === nextProps.enableBarChart && prevProps.from === nextProps.from && prevProps.grow === nextProps.grow && prevProps.loading === nextProps.loading && prevProps.setQuerySkip === nextProps.setQuerySkip && prevProps.id === nextProps.id && prevProps.index === nextProps.index && prevProps.updateDateRange === nextProps.updateDateRange && prevProps.statKey === nextProps.statKey && prevProps.to === nextProps.to && (0, _fastDeepEqual.default)(prevProps.areaChart, nextProps.areaChart) && (0, _fastDeepEqual.default)(prevProps.barChart, nextProps.barChart) && (0, _fastDeepEqual.default)(prevProps.fields, nextProps.fields));
exports.StatItemsComponent = StatItemsComponent;
StatItemsComponent.displayName = 'StatItemsComponent';