"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_WARNING_TITLE = exports.USER_WARNING_BODY = exports.TECHNICAL_PREVIEW = exports.RESTART_TOOLTIP = exports.HOST_WARNING_TITLE = exports.HOST_WARNING_BODY = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TECHNICAL_PREVIEW = _i18n.i18n.translate('xpack.securitySolution.riskScore.technicalPreviewLabel', {
  defaultMessage: 'Technical Preview'
});
exports.TECHNICAL_PREVIEW = TECHNICAL_PREVIEW;
const HOST_WARNING_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.hostsDashboardWarningPanelTitle', {
  defaultMessage: 'No host risk score data available to display'
});
exports.HOST_WARNING_TITLE = HOST_WARNING_TITLE;
const USER_WARNING_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.usersDashboardWarningPanelTitle', {
  defaultMessage: 'No user risk score data available to display'
});
exports.USER_WARNING_TITLE = USER_WARNING_TITLE;
const HOST_WARNING_BODY = _i18n.i18n.translate('xpack.securitySolution.riskScore.hostsDashboardWarningPanelBody', {
  defaultMessage: `We haven’t found any host risk score data. Check if you have any global filters in the global KQL search bar. If you have just enabled the host risk module, the risk engine might need an hour to generate host risk score data and display in this panel.`
});
exports.HOST_WARNING_BODY = HOST_WARNING_BODY;
const USER_WARNING_BODY = _i18n.i18n.translate('xpack.securitySolution.riskScore.usersDashboardWarningPanelBody', {
  defaultMessage: `We haven’t found any user risk score data. Check if you have any global filters in the global KQL search bar. If you have just enabled the user risk module, the risk engine might need an hour to generate user risk score data and display in this panel.`
});
exports.USER_WARNING_BODY = USER_WARNING_BODY;
const RESTART_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.riskScore.usersDashboardRestartTooltip', {
  defaultMessage: 'The risk score calculation might take a while to run. However, by pressing restart, you can force it to run immediately.'
});
exports.RESTART_TOOLTIP = RESTART_TOOLTIP;