"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNKNOWN_RISK_DESCRIPTION = exports.TITLE = exports.INTRODUCTION = exports.INFO_BUTTON_TEXT = exports.INFORMATION_RISK_HEADER = exports.INFORMATION_CLASSIFICATION_HEADER = exports.INFORMATION_ARIA_LABEL = exports.EXPLANATION_MESSAGE = exports.CRITICAL_RISK_DESCRIPTION = exports.CLOSE_BUTTON_LTEXT = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INFORMATION_CLASSIFICATION_HEADER = _i18n.i18n.translate('xpack.securitySolution.riskInformation.classificationHeader', {
  defaultMessage: 'Classification'
});
exports.INFORMATION_CLASSIFICATION_HEADER = INFORMATION_CLASSIFICATION_HEADER;
const INFORMATION_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.riskInformation.informationAriaLabel', {
  defaultMessage: 'Information'
});
exports.INFORMATION_ARIA_LABEL = INFORMATION_ARIA_LABEL;
const INFORMATION_RISK_HEADER = riskEntity => _i18n.i18n.translate('xpack.securitySolution.riskInformation.riskHeader', {
  defaultMessage: '{riskEntity} risk score range',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity)
  }
});
exports.INFORMATION_RISK_HEADER = INFORMATION_RISK_HEADER;
const UNKNOWN_RISK_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.riskInformation.unknownRiskDescription', {
  defaultMessage: 'Less than 20'
});
exports.UNKNOWN_RISK_DESCRIPTION = UNKNOWN_RISK_DESCRIPTION;
const CRITICAL_RISK_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.riskInformation.criticalRiskDescription', {
  defaultMessage: '90 and above'
});
exports.CRITICAL_RISK_DESCRIPTION = CRITICAL_RISK_DESCRIPTION;
const TITLE = riskEntity => _i18n.i18n.translate('xpack.securitySolution.riskInformation.title', {
  defaultMessage: 'How is {riskEntity} risk calculated?',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity, true)
  }
});
exports.TITLE = TITLE;
const INTRODUCTION = riskEntity => _i18n.i18n.translate('xpack.securitySolution.riskInformation.introduction', {
  defaultMessage: 'The {riskEntity} Risk Score capability surfaces risky {riskEntityLowerPlural} from within your environment.',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity),
    riskEntityLowerPlural: (0, _translations.getRiskEntityTranslation)(riskEntity, true, true)
  }
});
exports.INTRODUCTION = INTRODUCTION;
const EXPLANATION_MESSAGE = riskEntity => _i18n.i18n.translate('xpack.securitySolution.riskInformation.explanation', {
  defaultMessage: 'This feature utilizes a transform, with a scripted metric aggregation to calculate {riskEntityLower} risk scores based on detection rule alerts with an "open" status, within a 5 day time window. The transform runs hourly to keep the score updated as new detection rule alerts stream in.',
  values: {
    riskEntityLower: (0, _translations.getRiskEntityTranslation)(riskEntity, true)
  }
});
exports.EXPLANATION_MESSAGE = EXPLANATION_MESSAGE;
const CLOSE_BUTTON_LTEXT = _i18n.i18n.translate('xpack.securitySolution.riskInformation.closeBtn', {
  defaultMessage: 'Close'
});
exports.CLOSE_BUTTON_LTEXT = CLOSE_BUTTON_LTEXT;
const INFO_BUTTON_TEXT = _i18n.i18n.translate('xpack.securitySolution.riskInformation.buttonLabel', {
  defaultMessage: 'How is risk score calculated?'
});
exports.INFO_BUTTON_TEXT = INFO_BUTTON_TEXT;