"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_RISK_INFO_BUTTON_CLASS = exports.RiskInformationButtonIcon = exports.RiskInformationButtonEmpty = exports.HOST_RISK_INFO_BUTTON_CLASS = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _translations = require("../translations");
var i18n = _interopRequireWildcard(require("./translations"));
var _helper_hooks = require("../../../../helper_hooks");
var _common = require("../severity/common");
var _search_strategy = require("../../../../../common/search_strategy");
var _risk_score_doc_link = require("../risk_score_onboarding/risk_score_doc_link");
var _translations3 = require("../risk_score_onboarding/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTableColumns = riskEntity => [{
  field: 'classification',
  name: i18n.INFORMATION_CLASSIFICATION_HEADER,
  render: riskScore => {
    if (riskScore != null) {
      return /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
        severity: riskScore,
        hideBackgroundColor: true
      });
    }
  }
}, {
  field: 'range',
  name: i18n.INFORMATION_RISK_HEADER(riskEntity)
}];
const tableItems = [{
  classification: _search_strategy.RiskSeverity.critical,
  range: i18n.CRITICAL_RISK_DESCRIPTION
}, {
  classification: _search_strategy.RiskSeverity.high,
  range: '70 - 90 '
}, {
  classification: _search_strategy.RiskSeverity.moderate,
  range: '40 - 70'
}, {
  classification: _search_strategy.RiskSeverity.low,
  range: '20 - 40'
}, {
  classification: _search_strategy.RiskSeverity.unknown,
  range: i18n.UNKNOWN_RISK_DESCRIPTION
}];
const HOST_RISK_INFO_BUTTON_CLASS = 'HostRiskInformation__button';
exports.HOST_RISK_INFO_BUTTON_CLASS = HOST_RISK_INFO_BUTTON_CLASS;
const USER_RISK_INFO_BUTTON_CLASS = 'UserRiskInformation__button';
exports.USER_RISK_INFO_BUTTON_CLASS = USER_RISK_INFO_BUTTON_CLASS;
const RiskInformationButtonIcon = ({
  riskEntity
}) => {
  const [isFlyoutVisible, handleOnOpen, handleOnClose] = (0, _helper_hooks.useOnOpenCloseHandler)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconSize: "m",
    iconType: "iInCircle",
    "aria-label": i18n.INFORMATION_ARIA_LABEL,
    onClick: handleOnOpen,
    className: riskEntity === _search_strategy.RiskScoreEntity.host ? HOST_RISK_INFO_BUTTON_CLASS : USER_RISK_INFO_BUTTON_CLASS,
    "data-test-subj": "open-risk-information-flyout-trigger"
  }), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(RiskInformationFlyout, {
    riskEntity: riskEntity,
    handleOnClose: handleOnClose
  }));
};
exports.RiskInformationButtonIcon = RiskInformationButtonIcon;
const RiskInformationButtonEmpty = ({
  riskEntity
}) => {
  const [isFlyoutVisible, handleOnOpen, handleOnClose] = (0, _helper_hooks.useOnOpenCloseHandler)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: handleOnOpen,
    "data-test-subj": "open-risk-information-flyout-trigger"
  }, i18n.INFO_BUTTON_TEXT), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(RiskInformationFlyout, {
    riskEntity: riskEntity,
    handleOnClose: handleOnClose
  }));
};
exports.RiskInformationButtonEmpty = RiskInformationButtonEmpty;
const RiskInformationFlyout = ({
  handleOnClose,
  riskEntity
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const simpleFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'RiskInformation'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: handleOnClose,
    "aria-labelledby": simpleFlyoutTitleId,
    size: 450,
    "data-test-subj": "open-risk-information-flyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: simpleFlyoutTitleId
  }, i18n.TITLE(riskEntity))), /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _translations3.TECHNICAL_PREVIEW,
    size: "s",
    css: (0, _react2.css)`
            color: ${euiTheme.colors.text};
            margin-top: ${euiTheme.size.xxs};
          `
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.INTRODUCTION(riskEntity)), /*#__PURE__*/_react.default.createElement("p", null, i18n.EXPLANATION_MESSAGE(riskEntity))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: getTableColumns(riskEntity),
    items: tableItems,
    "data-test-subj": "risk-information-table"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskInformation.learnMore",
    defaultMessage: "You can learn more about {riskEntity} risk {riskScoreDocumentationLink}",
    values: {
      riskScoreDocumentationLink: /*#__PURE__*/_react.default.createElement(_risk_score_doc_link.RiskScoreDocLink, {
        riskScoreEntity: riskEntity,
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.riskInformation.link",
          defaultMessage: "here"
        })
      }),
      riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity, true)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleOnClose
  }, i18n.CLOSE_BUTTON_LTEXT)))));
};