"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListsDetailViewComponent = exports.ListsDetailView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _constants = require("../../../../common/constants");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _reference_error_modal = require("../../../detections/components/value_lists_management_flyout/reference_error_modal");
var _missing_privileges_callout = require("../../../detections/components/callouts/missing_privileges_callout");
var _ = require("../../../app/404");
var _auto_download = require("../../../common/components/auto_download/auto_download");
var _components = require("../../components");
var _hooks = require("../../hooks");
var i18n = _interopRequireWildcard(require("../../translations"));
var _expired_exceptions_list_items_modal = require("../../components/expired_exceptions_list_items_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ListsDetailViewComponent = () => {
  const {
    detailName: exceptionListId
  } = (0, _reactRouterDom.useParams)();
  const {
    isLoading,
    invalidListId,
    isReadOnly,
    list,
    canUserEditList,
    listId,
    linkedRules,
    exportedList,
    handleOnDownload,
    viewerStatus,
    listName,
    listDescription,
    showManageRulesFlyout,
    headerBackOptions,
    showReferenceErrorModal,
    referenceModalState,
    showManageButtonLoader,
    refreshExceptions,
    disableManageButton,
    onEditListDetails,
    onDuplicateList,
    onExportList,
    onManageRules,
    onSaveManageRules,
    onCancelManageRules,
    onRuleSelectionChange,
    handleDelete,
    handleCloseReferenceErrorModal,
    handleReferenceDelete
  } = (0, _hooks.useListDetailsView)(exceptionListId);
  const [showIncludeExpiredExceptionItemsModal, setShowIncludeExpiredExceptionItemsModal] = (0, _react.useState)(null);
  const onModalClose = (0, _react.useCallback)(() => setShowIncludeExpiredExceptionItemsModal(null), [setShowIncludeExpiredExceptionItemsModal]);
  const onModalOpen = (0, _react.useCallback)(actionType => {
    setShowIncludeExpiredExceptionItemsModal(actionType);
  }, [setShowIncludeExpiredExceptionItemsModal]);
  const handleExportList = (0, _react.useCallback)(() => {
    if ((list === null || list === void 0 ? void 0 : list.type) === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT) {
      onExportList(true);
    } else {
      onModalOpen('export');
    }
  }, [onModalOpen, list, onExportList]);
  const handleDuplicateList = (0, _react.useCallback)(() => {
    onModalOpen('duplicate');
  }, [onModalOpen]);
  const detailsViewContent = (0, _react.useMemo)(() => {
    if (viewerStatus === _securitysolutionExceptionListComponents.ViewerStatus.ERROR) return /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.EmptyViewerState, {
      isReadOnly: isReadOnly,
      viewerStatus: viewerStatus
    });
    if (isLoading) return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 4,
      "data-test-subj": "loading"
    });
    if (invalidListId || !listName || !list) return /*#__PURE__*/_react.default.createElement(_.NotFoundPage, null);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_missing_privileges_callout.MissingPrivilegesCallOut, null), /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.ExceptionListHeader, {
      name: listName,
      description: listDescription,
      listId: listId,
      linkedRules: linkedRules,
      isReadonly: isReadOnly,
      canUserEditList: canUserEditList,
      backOptions: headerBackOptions,
      securityLinkAnchorComponent: _components.ListDetailsLinkAnchor,
      onEditListDetails: onEditListDetails,
      onExportList: handleExportList,
      onDeleteList: handleDelete,
      onManageRules: onManageRules,
      onDuplicateList: handleDuplicateList,
      dataTestSubj: "exceptionListManagement"
    }), /*#__PURE__*/_react.default.createElement(_auto_download.AutoDownload, {
      blob: exportedList,
      name: `${listId}.ndjson`,
      onDownload: handleOnDownload
    }), /*#__PURE__*/_react.default.createElement(_components.ListWithSearch, {
      list: list,
      refreshExceptions: refreshExceptions,
      isReadOnly: isReadOnly
    }), /*#__PURE__*/_react.default.createElement(_reference_error_modal.ReferenceErrorModal, {
      cancelText: i18n.REFERENCE_MODAL_CANCEL_BUTTON,
      confirmText: i18n.REFERENCE_MODAL_CONFIRM_BUTTON,
      contentText: referenceModalState.contentText,
      onCancel: handleCloseReferenceErrorModal,
      onClose: handleCloseReferenceErrorModal,
      onConfirm: handleReferenceDelete,
      references: referenceModalState.rulesReferences,
      showModal: showReferenceErrorModal,
      titleText: i18n.REFERENCE_MODAL_TITLE
    }), showManageRulesFlyout ? /*#__PURE__*/_react.default.createElement(_components.ManageRules, {
      linkedRules: linkedRules,
      showButtonLoader: showManageButtonLoader,
      saveIsDisabled: disableManageButton,
      onSave: onSaveManageRules,
      onCancel: onCancelManageRules,
      onRuleSelectionChange: onRuleSelectionChange
    }) : null, showIncludeExpiredExceptionItemsModal && /*#__PURE__*/_react.default.createElement(_expired_exceptions_list_items_modal.IncludeExpiredExceptionsModal, {
      onModalConfirm: showIncludeExpiredExceptionItemsModal === 'export' ? onExportList : onDuplicateList,
      handleCloseModal: onModalClose,
      action: showIncludeExpiredExceptionItemsModal
    }));
  }, [viewerStatus, isReadOnly, isLoading, invalidListId, listName, list, listDescription, listId, linkedRules, canUserEditList, headerBackOptions, onEditListDetails, handleExportList, handleDelete, onManageRules, handleDuplicateList, exportedList, handleOnDownload, refreshExceptions, referenceModalState.contentText, referenceModalState.rulesReferences, handleCloseReferenceErrorModal, handleReferenceDelete, showReferenceErrorModal, showManageRulesFlyout, showManageButtonLoader, disableManageButton, onSaveManageRules, onCancelManageRules, onRuleSelectionChange, showIncludeExpiredExceptionItemsModal, onExportList, onDuplicateList, onModalClose]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.exceptions,
    state: {
      listName
    }
  }), detailsViewContent);
};
exports.ListsDetailViewComponent = ListsDetailViewComponent;
ListsDetailViewComponent.displayName = 'ListsDetailViewComponent';
const ListsDetailView = /*#__PURE__*/_react.default.memo(ListsDetailViewComponent);
exports.ListsDetailView = ListsDetailView;
ListsDetailView.displayName = 'ListsDetailView';