"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOptionProperties = exports.getContextMenuPanels = exports.getButtonProperties = exports.TREND_ID = exports.TREEMAP_ID = exports.TABLE_ID = exports.CHARTS_ID = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TABLE_ID = 'table';
exports.TABLE_ID = TABLE_ID;
const TREND_ID = 'trend';
exports.TREND_ID = TREND_ID;
const TREEMAP_ID = 'treemap';
exports.TREEMAP_ID = TREEMAP_ID;
const CHARTS_ID = 'charts';
exports.CHARTS_ID = CHARTS_ID;
const getButtonProperties = alertViewSelection => {
  const table = {
    'data-test-subj': alertViewSelection,
    icon: 'visTable',
    name: i18n.TABLE
  };
  switch (alertViewSelection) {
    case TABLE_ID:
      return table;
    case TREND_ID:
      return {
        'data-test-subj': alertViewSelection,
        icon: 'visBarVerticalStacked',
        name: i18n.TREND
      };
    case TREEMAP_ID:
      return {
        'data-test-subj': alertViewSelection,
        icon: 'grid',
        name: i18n.TREEMAP
      };
    case CHARTS_ID:
      return {
        'data-test-subj': alertViewSelection,
        icon: 'visPie',
        name: i18n.CHARTS
      };
    default:
      return table;
  }
};
exports.getButtonProperties = getButtonProperties;
const getContextMenuPanels = ({
  alertViewSelection,
  closePopover,
  setAlertViewSelection,
  isAlertsPageChartsEnabled
}) => [{
  id: 0,
  items: [{
    ...getButtonProperties('table'),
    onClick: () => {
      closePopover();
      setAlertViewSelection('table');
    }
  }, {
    ...getButtonProperties('trend'),
    onClick: () => {
      closePopover();
      setAlertViewSelection('trend');
    }
  }, {
    ...getButtonProperties('treemap'),
    onClick: () => {
      closePopover();
      setAlertViewSelection('treemap');
    }
  }, ...(isAlertsPageChartsEnabled ? [{
    ...getButtonProperties('charts'),
    onClick: () => {
      closePopover();
      setAlertViewSelection('charts');
    }
  }] : [])]
}];
exports.getContextMenuPanels = getContextMenuPanels;
const getOptionProperties = alertViewSelection => {
  const charts = {
    id: CHARTS_ID,
    'data-test-subj': `chart-select-${CHARTS_ID}`,
    label: i18n.CHARTS_TITLE,
    value: CHARTS_ID
  };
  switch (alertViewSelection) {
    case TABLE_ID:
      return {
        id: TABLE_ID,
        'data-test-subj': `chart-select-${TABLE_ID}`,
        label: i18n.COUNTS,
        value: TABLE_ID
      };
    case TREND_ID:
      return {
        id: TREND_ID,
        'data-test-subj': `chart-select-${TREND_ID}`,
        label: i18n.TREND,
        value: TREND_ID
      };
    case TREEMAP_ID:
      return {
        id: TREEMAP_ID,
        'data-test-subj': `chart-select-${TREEMAP_ID}`,
        label: i18n.TREEMAP,
        value: TREEMAP_ID
      };
    case CHARTS_ID:
      return charts;
    default:
      return charts;
  }
};
exports.getOptionProperties = getOptionProperties;