"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_CATEGORY = exports.TREND_CHART_CATEGORY = exports.TREEMAP_CATEGORY = exports.TABLE_CATEGORY = exports.STACK_BY_SETTING_NAME = exports.STACK_BY_1_SETTING_NAME = exports.STACK_BY_0_SETTING_NAME = exports.GROUP_BY_SETTING_NAME = exports.EXPAND_SETTING_NAME = exports.ALERT_VIEW_SELECTION_SETTING_NAME = exports.ALERTS_PAGE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** settings for the `Alerts` page are grouped under this logical key */
const ALERTS_PAGE = 'alerts';

/** This setting persists the value of the view selector, which toggles between chart types */
exports.ALERTS_PAGE = ALERTS_PAGE;
const ALERT_VIEW_SELECTION_SETTING_NAME = 'alert-view-selection';

/** settings for the `Count` table visualization are grouped under this category */
exports.ALERT_VIEW_SELECTION_SETTING_NAME = ALERT_VIEW_SELECTION_SETTING_NAME;
const TABLE_CATEGORY = 'table';

/** This setting persists the expanded / collapsed state of an expandable panel */
exports.TABLE_CATEGORY = TABLE_CATEGORY;
const EXPAND_SETTING_NAME = 'expand';

/** settings for the `Treemap` visualization are grouped under this category */
exports.EXPAND_SETTING_NAME = EXPAND_SETTING_NAME;
const TREEMAP_CATEGORY = 'treemap';

/** This setting persists the value of the `Stack by` field selector */
exports.TREEMAP_CATEGORY = TREEMAP_CATEGORY;
const STACK_BY_SETTING_NAME = 'stack-by';

/** This setting persists the value of the first `Stack by` field selector when there are multiple */
exports.STACK_BY_SETTING_NAME = STACK_BY_SETTING_NAME;
const STACK_BY_0_SETTING_NAME = 'stack-by-0';

/** This setting persists the value of the second `Stack by` field selector when there are multiple */
exports.STACK_BY_0_SETTING_NAME = STACK_BY_0_SETTING_NAME;
const STACK_BY_1_SETTING_NAME = 'stack-by-1';

/** settings for the `Trend` visualization are grouped under this category */
exports.STACK_BY_1_SETTING_NAME = STACK_BY_1_SETTING_NAME;
const TREND_CHART_CATEGORY = 'trend';

/** settings for view selection are grouped under this category */
exports.TREND_CHART_CATEGORY = TREND_CHART_CATEGORY;
const VIEW_CATEGORY = 'view';

/** settings for group by selection on summary tab */
exports.VIEW_CATEGORY = VIEW_CATEGORY;
const GROUP_BY_SETTING_NAME = 'group-by';
exports.GROUP_BY_SETTING_NAME = GROUP_BY_SETTING_NAME;