"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulePanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _fp = require("lodash/fp");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _timeline = require("../../../../../../../common/types/timeline");
var _severity_badge = require("../../../../../components/rules/severity_badge");
var _helpers = require("../../../../../../common/components/event_details/helpers");
var _formatted_field = require("../../../../../../timelines/components/timeline/body/renderers/formatted_field");
var _translation = require("../translation");
var _get_mitre_threat_component = require("../../../../../mitre/get_mitre_threat_component");
var _get_timeline_event_data = require("../../../utils/get_timeline_event_data");
var _wrappers = require("../wrappers");
var _rule_panel_actions = require("./rule_panel_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const threatTacticContainerStyles = (0, _react2.css)`
  flex-wrap: nowrap;
  & .euiFlexGroup {
    flex-wrap: nowrap;
  }
`;
const RuleSection = ({
  grow,
  title,
  children,
  'data-test-subj': dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: grow,
  "data-test-subj": dataTestSubj
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xxs"
}, /*#__PURE__*/_react.default.createElement("h5", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), children);
const RulePanel = /*#__PURE__*/_react.default.memo(({
  data,
  id,
  searchHit,
  browserFields
}) => {
  var _ruleNameData$values, _ruleNameData$data$fi;
  const ruleUuid = (0, _react.useMemo)(() => (0, _get_timeline_event_data.getTimelineEventData)(_ruleDataUtils.ALERT_RULE_UUID, data), [data]);
  const threatDetails = (0, _react.useMemo)(() => (0, _get_mitre_threat_component.getMitreComponentParts)(searchHit), [searchHit]);
  const alertRiskScore = (0, _react.useMemo)(() => (0, _get_timeline_event_data.getTimelineEventData)(_ruleDataUtils.ALERT_RISK_SCORE, data), [data]);
  const alertSeverity = (0, _react.useMemo)(() => (0, _get_timeline_event_data.getTimelineEventData)(_ruleDataUtils.ALERT_SEVERITY, data), [data]);
  const alertRuleDescription = (0, _react.useMemo)(() => (0, _get_timeline_event_data.getTimelineEventData)(_ruleDataUtils.ALERT_RULE_DESCRIPTION, data), [data]);
  const shouldShowThreatDetails = !!threatDetails && (threatDetails === null || threatDetails === void 0 ? void 0 : threatDetails.length) > 0;
  const renderRuleActions = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_rule_panel_actions.RulePanelActions, {
    ruleUuid: ruleUuid
  }), [ruleUuid]);
  const ruleNameData = (0, _react.useMemo)(() => {
    const item = (0, _fp.find)({
      field: _ruleDataUtils.ALERT_RULE_NAME,
      category: _ruleDataUtils.KIBANA_NAMESPACE
    }, data);
    const linkValueField = (0, _fp.find)({
      field: _ruleDataUtils.ALERT_RULE_UUID,
      category: _ruleDataUtils.KIBANA_NAMESPACE
    }, data);
    return item && (0, _helpers.getEnrichedFieldInfo)({
      eventId: id,
      contextId: _timeline.TimelineId.detectionsAlertDetailsPage,
      scopeId: _timeline.TimelineId.detectionsAlertDetailsPage,
      browserFields,
      item,
      linkValueField
    });
  }, [browserFields, data, id]);
  return /*#__PURE__*/_react.default.createElement(_wrappers.SummaryPanel, {
    actionsClassName: _rule_panel_actions.RULE_PANEL_ACTIONS_CLASS,
    renderActionsPopover: renderRuleActions,
    title: _translation.RULE_PANEL_TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "rule-panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(RuleSection, {
    title: _translation.RULE_NAME_TITLE,
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
    contextId: _timeline.TimelineId.active,
    eventId: id,
    value: ruleNameData === null || ruleNameData === void 0 ? void 0 : (_ruleNameData$values = ruleNameData.values) === null || _ruleNameData$values === void 0 ? void 0 : _ruleNameData$values[0],
    fieldName: (_ruleNameData$data$fi = ruleNameData === null || ruleNameData === void 0 ? void 0 : ruleNameData.data.field) !== null && _ruleNameData$data$fi !== void 0 ? _ruleNameData$data$fi : '',
    linkValue: ruleNameData === null || ruleNameData === void 0 ? void 0 : ruleNameData.linkValue,
    fieldType: ruleNameData === null || ruleNameData === void 0 ? void 0 : ruleNameData.data.type,
    fieldFormat: ruleNameData === null || ruleNameData === void 0 ? void 0 : ruleNameData.data.format,
    isDraggable: false,
    truncate: false
  })), /*#__PURE__*/_react.default.createElement(RuleSection, {
    title: _translation.RISK_SCORE_TITLE
  }, alertRiskScore), /*#__PURE__*/_react.default.createElement(RuleSection, {
    "data-test-subj": "rule-panel-severity",
    title: _translation.SEVERITY_TITLE
  }, /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
    value: alertSeverity
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(RuleSection, {
    title: _translation.RULE_DESCRIPTION_TITLE,
    grow: 2
  }, alertRuleDescription)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "rule-panel-threat-tactic",
    wrap: false,
    css: threatTacticContainerStyles
  }, shouldShowThreatDetails && /*#__PURE__*/_react.default.createElement(RuleSection, {
    title: threatDetails[0].title,
    grow: 2
  }, threatDetails[0].description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))));
});
exports.RulePanel = RulePanel;
RulePanel.displayName = 'RulePanel';