"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostPanelActions = exports.HOST_PANEL_ACTIONS_CLASS = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../../../app/types");
var _links = require("../../../../../../common/components/links");
var _link_to = require("../../../../../../common/components/link_to");
var _translation = require("../translation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_PANEL_ACTIONS_CLASS = 'host-panel-actions-trigger';
exports.HOST_PANEL_ACTIONS_CLASS = HOST_PANEL_ACTIONS_CLASS;
const HostPanelActions = /*#__PURE__*/_react.default.memo(({
  className,
  openHostDetailsPanel,
  hostName
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const {
    href
  } = (0, _links.useGetSecuritySolutionLinkProps)()({
    deepLinkId: _types.SecurityPageName.hosts,
    path: (0, _link_to.getHostDetailsUrl)(hostName)
  });
  const onButtonClick = (0, _react.useCallback)(() => {
    setPopover(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = () => {
    setPopover(false);
  };
  const handleOpenHostDetailsPanel = (0, _react.useCallback)(() => {
    openHostDetailsPanel(hostName);
    closePopover();
  }, [hostName, openHostDetailsPanel]);
  const items = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "expand",
    key: "hostActionsViewHostSummary",
    onClick: handleOpenHostDetailsPanel,
    "data-test-subj": "host-panel-actions-view-summary"
  }, _translation.VIEW_HOST_SUMMARY), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "popout",
    key: "hostActionsOpenHostDetailsPage",
    "data-test-subj": "host-panel-actions-open-host-details",
    onClick: closePopover,
    href: href,
    target: "_blank"
  }, _translation.OPEN_HOST_DETAILS_PAGE)], [handleOpenHostDetailsPanel, href]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translation.SUMMARY_PANEL_ACTIONS,
    className: HOST_PANEL_ACTIONS_CLASS,
    iconType: "boxesHorizontal",
    onClick: onButtonClick
  }), [onButtonClick]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: className
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    panelClassName: "withHoverActions__popover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "host-actions-panel",
    size: "s",
    items: items
  })));
});
exports.HostPanelActions = HostPanelActions;
HostPanelActions.displayName = 'HostPanelActions';