"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_ALERT_STATUS_FAILED_DETAILED = exports.UPDATE_ALERT_STATUS_FAILED = exports.SELECT_ALL_ALERTS = exports.SELECTED_ALERTS = exports.OPENED_ALERT_SUCCESS_TOAST = exports.OPENED_ALERT_FAILED_TOAST = exports.CLOSED_ALERT_SUCCESS_TOAST = exports.CLOSED_ALERT_FAILED_TOAST = exports.CLEAR_SELECTION = exports.BULK_ACTION_OPEN_SELECTED = exports.BULK_ACTION_FAILED_SINGLE_ALERT = exports.BULK_ACTION_CLOSE_SELECTED = exports.BULK_ACTION_ACKNOWLEDGED_SELECTED = exports.ACKNOWLEDGED_ALERT_SUCCESS_TOAST = exports.ACKNOWLEDGED_ALERT_FAILED_TOAST = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SELECTED_ALERTS = (selectedAlertsFormatted, selectedAlerts) => _i18n.i18n.translate('xpack.securitySolution.toolbar.bulkActions.selectedAlertsTitle', {
  values: {
    selectedAlertsFormatted,
    selectedAlerts
  },
  defaultMessage: 'Selected {selectedAlertsFormatted} {selectedAlerts, plural, =1 {alert} other {alerts}}'
});
exports.SELECTED_ALERTS = SELECTED_ALERTS;
const SELECT_ALL_ALERTS = (totalAlertsFormatted, totalAlerts) => _i18n.i18n.translate('xpack.securitySolution.toolbar.bulkActions.selectAllAlertsTitle', {
  values: {
    totalAlertsFormatted,
    totalAlerts
  },
  defaultMessage: 'Select all {totalAlertsFormatted} {totalAlerts, plural, =1 {alert} other {alerts}}'
});
exports.SELECT_ALL_ALERTS = SELECT_ALL_ALERTS;
const CLEAR_SELECTION = _i18n.i18n.translate('xpack.securitySolution.toolbar.bulkActions.clearSelectionTitle', {
  defaultMessage: 'Clear selection'
});
exports.CLEAR_SELECTION = CLEAR_SELECTION;
const UPDATE_ALERT_STATUS_FAILED = conflicts => _i18n.i18n.translate('xpack.securitySolution.bulkActions.updateAlertStatusFailed', {
  values: {
    conflicts
  },
  defaultMessage: 'Failed to update { conflicts } {conflicts, plural, =1 {alert} other {alerts}}.'
});
exports.UPDATE_ALERT_STATUS_FAILED = UPDATE_ALERT_STATUS_FAILED;
const UPDATE_ALERT_STATUS_FAILED_DETAILED = (updated, conflicts) => _i18n.i18n.translate('xpack.securitySolution.bulkActions.updateAlertStatusFailedDetailed', {
  values: {
    updated,
    conflicts
  },
  defaultMessage: `{ updated } {updated, plural, =1 {alert was} other {alerts were}} updated successfully, but { conflicts } failed to update
         because { conflicts, plural, =1 {it was} other {they were}} already being modified.`
});
exports.UPDATE_ALERT_STATUS_FAILED_DETAILED = UPDATE_ALERT_STATUS_FAILED_DETAILED;
const CLOSED_ALERT_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.bulkActions.closedAlertSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully closed {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}}.'
});
exports.CLOSED_ALERT_SUCCESS_TOAST = CLOSED_ALERT_SUCCESS_TOAST;
const OPENED_ALERT_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.bulkActions.openedAlertSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully opened {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}}.'
});
exports.OPENED_ALERT_SUCCESS_TOAST = OPENED_ALERT_SUCCESS_TOAST;
const ACKNOWLEDGED_ALERT_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.bulkActions.acknowledgedAlertSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully marked {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}} as acknowledged.'
});
exports.ACKNOWLEDGED_ALERT_SUCCESS_TOAST = ACKNOWLEDGED_ALERT_SUCCESS_TOAST;
const CLOSED_ALERT_FAILED_TOAST = _i18n.i18n.translate('xpack.securitySolution.bulkActions.closedAlertFailedToastMessage', {
  defaultMessage: 'Failed to close alert(s).'
});
exports.CLOSED_ALERT_FAILED_TOAST = CLOSED_ALERT_FAILED_TOAST;
const OPENED_ALERT_FAILED_TOAST = _i18n.i18n.translate('xpack.securitySolution.bulkActions.openedAlertFailedToastMessage', {
  defaultMessage: 'Failed to open alert(s)'
});
exports.OPENED_ALERT_FAILED_TOAST = OPENED_ALERT_FAILED_TOAST;
const ACKNOWLEDGED_ALERT_FAILED_TOAST = _i18n.i18n.translate('xpack.securitySolution.bulkActions.acknowledgedAlertFailedToastMessage', {
  defaultMessage: 'Failed to mark alert(s) as acknowledged'
});
exports.ACKNOWLEDGED_ALERT_FAILED_TOAST = ACKNOWLEDGED_ALERT_FAILED_TOAST;
const BULK_ACTION_FAILED_SINGLE_ALERT = _i18n.i18n.translate('xpack.securitySolution.bulkActions.updateAlertStatusFailedSingleAlert', {
  defaultMessage: 'Failed to update alert because it was already being modified.'
});
exports.BULK_ACTION_FAILED_SINGLE_ALERT = BULK_ACTION_FAILED_SINGLE_ALERT;
const BULK_ACTION_OPEN_SELECTED = _i18n.i18n.translate('xpack.securitySolution.bulkActions.openSelectedTitle', {
  defaultMessage: 'Mark as open'
});
exports.BULK_ACTION_OPEN_SELECTED = BULK_ACTION_OPEN_SELECTED;
const BULK_ACTION_ACKNOWLEDGED_SELECTED = _i18n.i18n.translate('xpack.securitySolution.bulkActions.acknowledgedSelectedTitle', {
  defaultMessage: 'Mark as acknowledged'
});
exports.BULK_ACTION_ACKNOWLEDGED_SELECTED = BULK_ACTION_ACKNOWLEDGED_SELECTED;
const BULK_ACTION_CLOSE_SELECTED = _i18n.i18n.translate('xpack.securitySolution.bulkActions.closeSelectedTitle', {
  defaultMessage: 'Mark as closed'
});
exports.BULK_ACTION_CLOSE_SELECTED = BULK_ACTION_CLOSE_SELECTED;