"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateMustache = exports.validateActionParams = exports.getActionTypeName = void 0;
var _mustache = _interopRequireDefault(require("mustache"));
var _fp = require("lodash/fp");
var I18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getActionTypeName = actionTypeId => {
  if (!actionTypeId) return '';
  const actionType = actionTypeId.split('.')[1];
  if (!actionType) return '';
  return (0, _fp.startCase)(actionType);
};
exports.getActionTypeName = getActionTypeName;
const validateMustache = params => {
  const errors = [];
  Object.entries(params).forEach(([paramKey, paramValue]) => {
    if (!(0, _fp.isString)(paramValue)) return;
    try {
      _mustache.default.render(paramValue, {});
    } catch (e) {
      errors.push(I18n.INVALID_MUSTACHE_TEMPLATE(paramKey));
    }
  });
  return errors;
};
exports.validateMustache = validateMustache;
const validateActionParams = async (actionItem, actionTypeRegistry) => {
  var _actionTypeRegistry$g;
  const actionErrors = await ((_actionTypeRegistry$g = actionTypeRegistry.get(actionItem.actionTypeId)) === null || _actionTypeRegistry$g === void 0 ? void 0 : _actionTypeRegistry$g.validateParams(actionItem.params));
  if (actionErrors) {
    const actionErrorsValues = Object.values(actionErrors.errors);
    if (actionErrorsValues.length) {
      const filteredObjects = actionErrorsValues.filter(item => (0, _fp.isString)(item) || (0, _fp.isArray)(item));
      const uniqActionErrors = (0, _fp.uniq)((0, _fp.flattenDeep)(filteredObjects));
      if (uniqActionErrors.length) {
        return uniqActionErrors;
      }
    }
  }
  return [];
};
exports.validateActionParams = validateActionParams;