"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRenderCellValueHook = exports.RenderCellValue = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_license = require("../../../common/hooks/use_license");
var _use_selector = require("../../../common/hooks/use_selector");
var _renderers = require("../../../timelines/components/timeline/body/renderers");
var _tour_step = require("../../../common/components/guided_onboarding_tour/tour_step");
var _helpers = require("../../../common/components/top_n/helpers");
var _tour_config = require("../../../common/components/guided_onboarding_tour/tour_config");
var _constants = require("../../../timelines/components/timeline/body/renderers/constants");
var _sourcerer = require("../../../common/containers/sourcerer");
var _default_cell_renderer = require("../../../timelines/components/timeline/cell_rendering/default_cell_renderer");
var _translations = require("./translations");
var _constants2 = require("../../../../common/constants");
var _source = require("../../../common/containers/source");
var _columns = require("./columns");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This implementation of `EuiDataGrid`'s `renderCellValue`
 * accepts `EuiDataGridCellValueElementProps`, plus `data`
 * from the TGrid
 */
const RenderCellValue = props => {
  var _props$ecsData, _props$ecsData$kibana, _props$ecsData$kibana2, _props$ecsData$kibana3, _find, _find$value;
  const {
    columnId,
    rowIndex,
    scopeId
  } = props;
  const isTourAnchor = (0, _react.useMemo)(() => columnId === _constants.SIGNAL_RULE_NAME_FIELD_NAME && (0, _helpers.isDetectionsAlertsTable)(scopeId) && rowIndex === 0 && !props.isDetails, [columnId, props.isDetails, rowIndex, scopeId]);

  // We check both ecsData and data for the suppression count because it could be in either one,
  // depending on where RenderCellValue is being used - when used in cases, data is populated,
  // whereas in the regular security alerts table it's in ecsData
  const ecsSuppressionCount = (_props$ecsData = props.ecsData) === null || _props$ecsData === void 0 ? void 0 : (_props$ecsData$kibana = _props$ecsData.kibana) === null || _props$ecsData$kibana === void 0 ? void 0 : (_props$ecsData$kibana2 = _props$ecsData$kibana.alert.suppression) === null || _props$ecsData$kibana2 === void 0 ? void 0 : (_props$ecsData$kibana3 = _props$ecsData$kibana2.docs_count) === null || _props$ecsData$kibana3 === void 0 ? void 0 : _props$ecsData$kibana3[0];
  const dataSuppressionCount = (_find = (0, _fp.find)({
    field: 'kibana.alert.suppression.docs_count'
  }, props.data)) === null || _find === void 0 ? void 0 : (_find$value = _find.value) === null || _find$value === void 0 ? void 0 : _find$value[0];
  const actualSuppressionCount = ecsSuppressionCount ? parseInt(ecsSuppressionCount, 10) : dataSuppressionCount;
  const component = /*#__PURE__*/_react.default.createElement(_tour_step.GuidedOnboardingTourStep, {
    isTourAnchor: isTourAnchor,
    step: _tour_config.AlertsCasesTourSteps.pointToAlertName,
    tourId: _tour_config.SecurityStepId.alertsCases
  }, /*#__PURE__*/_react.default.createElement(_default_cell_renderer.DefaultCellRenderer, props));
  return columnId === _constants.SIGNAL_RULE_NAME_FIELD_NAME && actualSuppressionCount && actualSuppressionCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: (0, _translations.SUPPRESSED_ALERT_TOOLTIP)(actualSuppressionCount)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "layers"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, component)) : component;
};
exports.RenderCellValue = RenderCellValue;
const getRenderCellValueHook = ({
  scopeId,
  tableId
}) => {
  const useRenderCellValue = () => {
    var _useShallowEqualSelec;
    const {
      browserFields
    } = (0, _sourcerer.useSourcererDataView)(scopeId);
    const browserFieldsByName = (0, _react.useMemo)(() => (0, _source.getAllFieldsByName)(browserFields), [browserFields]);
    const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
    const license = (0, _use_license.useLicense)();
    const viewMode = (_useShallowEqualSelec = (0, _use_selector.useShallowEqualSelector)(state => {
      var _getTable;
      return ((_getTable = getTable(state, tableId)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).viewMode;
    })) !== null && _useShallowEqualSelec !== void 0 ? _useShallowEqualSelec : _securitysolutionDataTable.tableDefaults.viewMode;
    const columnHeaders = viewMode === _constants2.VIEW_SELECTION.gridView ? (0, _columns.getColumns)(license) : _columns.eventRenderedViewColumns;
    const result = (0, _react.useCallback)(({
      columnId,
      colIndex,
      data,
      ecsData,
      eventId,
      header,
      isDetails = false,
      isDraggable = false,
      isExpandable,
      isExpanded,
      rowIndex,
      rowRenderers,
      setCellProps,
      linkValues,
      truncate = true
    }) => {
      var _colHeader$linkField;
      const myHeader = header !== null && header !== void 0 ? header : {
        id: columnId,
        ...browserFieldsByName[columnId]
      };
      /**
       * There is difference between how `triggers actions` fetched data v/s
       * how security solution fetches data via timelineSearchStrategy
       *
       * _id and _index fields are array in timelineSearchStrategy  but not in
       * ruleStrategy
       *
       *
       */

      const finalData = data.map(field => {
        let localField = field;
        if (['_id', '_index'].includes(field.field)) {
          var _field$value;
          const newValue = (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : '';
          localField = {
            field: field.field,
            value: Array.isArray(newValue) ? newValue : [newValue]
          };
        }
        return localField;
      });
      const colHeader = columnHeaders.find(col => col.id === columnId);
      const localLinkValues = (0, _fp.getOr)([], (_colHeader$linkField = colHeader === null || colHeader === void 0 ? void 0 : colHeader.linkField) !== null && _colHeader$linkField !== void 0 ? _colHeader$linkField : '', ecsData);
      return /*#__PURE__*/_react.default.createElement(RenderCellValue, {
        browserFields: browserFields,
        columnId: columnId,
        data: finalData,
        ecsData: ecsData,
        eventId: eventId,
        header: myHeader,
        isDetails: isDetails,
        isDraggable: isDraggable,
        isExpandable: isExpandable,
        isExpanded: isExpanded,
        linkValues: linkValues !== null && linkValues !== void 0 ? linkValues : localLinkValues,
        rowIndex: rowIndex,
        colIndex: colIndex,
        rowRenderers: rowRenderers !== null && rowRenderers !== void 0 ? rowRenderers : _renderers.defaultRowRenderers,
        setCellProps: setCellProps,
        scopeId: tableId,
        truncate: truncate,
        asPlainText: false
      });
    }, [browserFieldsByName, browserFields, columnHeaders]);
    return result;
  };
  return useRenderCellValue;
};
exports.getRenderCellValueHook = getRenderCellValueHook;