"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TakeActionDropdown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _tour_step = require("../../../common/components/guided_onboarding_tour/tour_step");
var _tour_config = require("../../../common/components/guided_onboarding_tour/tour_config");
var _helpers = require("../../../helpers");
var _endpoint_responder = require("../endpoint_responder");
var _translations = require("../alerts_table/additional_filters_action/translations");
var _use_add_exception_actions = require("../alerts_table/timeline_actions/use_add_exception_actions");
var _use_alerts_actions = require("../alerts_table/timeline_actions/use_alerts_actions");
var _use_investigate_in_timeline = require("../alerts_table/timeline_actions/use_investigate_in_timeline");
var _use_event_filter_action = require("../alerts_table/timeline_actions/use_event_filter_action");
var _use_host_isolation_action = require("../host_isolation/use_host_isolation_action");
var _helpers2 = require("../host_isolation/helpers");
var _endpoint_alert_check = require("../../../common/utils/endpoint_alert_check");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _user_privileges = require("../../../common/components/user_privileges");
var _use_add_to_case_actions = require("../alerts_table/timeline_actions/use_add_to_case_actions");
var _kibana = require("../../../common/lib/kibana");
var _osquery_action_item = require("../osquery/osquery_action_item");
var _use_alert_tags_actions = require("../alerts_table/timeline_actions/use_alert_tags_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TakeActionDropdown = /*#__PURE__*/_react.default.memo(({
  detailsData,
  ecsData,
  handleOnEventClosed,
  indexName,
  isHostIsolationPanelOpen,
  loadingEventDetails,
  onAddEventFilterClick,
  onAddExceptionTypeClick,
  onAddIsolationStatusClick,
  refetch,
  refetchFlyoutData,
  onOsqueryClick,
  scopeId
}) => {
  var _detailsData$map;
  const tGridEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('tGridEnabled');
  const {
    loading: endpointPrivilegesLoading,
    canWriteEventFilters
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const canCreateEndpointEventFilters = (0, _react.useMemo)(() => !endpointPrivilegesLoading && canWriteEventFilters, [canWriteEventFilters, endpointPrivilegesLoading]);
  const {
    osquery
  } = (0, _kibana.useKibana)().services;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const actionsData = (0, _react.useMemo)(() => [{
    category: 'kibana',
    field: 'kibana.alert.rule.uuid',
    name: 'ruleId'
  }, {
    category: 'kibana',
    field: 'kibana.alert.rule.name',
    name: 'ruleName'
  }, {
    category: 'kibana',
    field: 'kibana.alert.workflow_status',
    name: 'alertStatus'
  }, {
    category: 'event',
    field: 'event.kind',
    name: 'eventKind'
  }, {
    category: '_id',
    field: '_id',
    name: 'eventId'
  }].reduce((acc, curr) => ({
    ...acc,
    [curr.name]: (0, _helpers2.getFieldValue)({
      category: curr.category,
      field: curr.field
    }, detailsData)
  }), {}), [detailsData]);
  const isEvent = actionsData.eventKind === 'event';
  const isAgentEndpoint = (0, _react.useMemo)(() => {
    var _ecsData$agent, _ecsData$agent$type;
    return ecsData === null || ecsData === void 0 ? void 0 : (_ecsData$agent = ecsData.agent) === null || _ecsData$agent === void 0 ? void 0 : (_ecsData$agent$type = _ecsData$agent.type) === null || _ecsData$agent$type === void 0 ? void 0 : _ecsData$agent$type.includes('endpoint');
  }, [ecsData]);
  const isEndpointEvent = (0, _react.useMemo)(() => isEvent && isAgentEndpoint, [isEvent, isAgentEndpoint]);
  const agentId = (0, _react.useMemo)(() => (0, _helpers2.getFieldValue)({
    category: 'agent',
    field: 'agent.id'
  }, detailsData), [detailsData]);
  const togglePopoverHandler = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopoverHandler = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const closePopoverAndFlyout = (0, _react.useCallback)(() => {
    handleOnEventClosed();
    setIsPopoverOpen(false);
  }, [handleOnEventClosed]);
  const handleOnAddIsolationStatusClick = (0, _react.useCallback)(action => {
    onAddIsolationStatusClick(action);
    setIsPopoverOpen(false);
  }, [onAddIsolationStatusClick]);
  const hostIsolationActionItems = (0, _use_host_isolation_action.useHostIsolationAction)({
    closePopover: closePopoverHandler,
    detailsData,
    onAddIsolationStatusClick: handleOnAddIsolationStatusClick,
    isHostIsolationPanelOpen
  });
  const endpointResponseActionsConsoleItems = (0, _endpoint_responder.useResponderActionItem)(detailsData, closePopoverHandler);
  const handleOnAddExceptionTypeClick = (0, _react.useCallback)(type => {
    onAddExceptionTypeClick(type);
    setIsPopoverOpen(false);
  }, [onAddExceptionTypeClick]);
  const {
    exceptionActionItems
  } = (0, _use_add_exception_actions.useExceptionActions)({
    isEndpointAlert: (0, _endpoint_alert_check.isAlertFromEndpointAlert)({
      ecsData
    }),
    onAddExceptionTypeClick: handleOnAddExceptionTypeClick
  });
  const handleOnAddEventFilterClick = (0, _react.useCallback)(() => {
    onAddEventFilterClick();
    setIsPopoverOpen(false);
  }, [onAddEventFilterClick]);
  const {
    eventFilterActionItems
  } = (0, _use_event_filter_action.useEventFilterAction)({
    onAddEventFilterClick: handleOnAddEventFilterClick
  });
  const onMenuItemClick = (0, _react.useCallback)(() => {
    closePopoverHandler();
  }, [closePopoverHandler]);
  const {
    actionItems: statusActionItems
  } = (0, _use_alerts_actions.useAlertsActions)({
    alertStatus: actionsData.alertStatus,
    closePopover: closePopoverAndFlyout,
    eventId: actionsData.eventId,
    indexName,
    refetch,
    scopeId
  });
  const {
    alertTagsItems,
    alertTagsPanels
  } = (0, _use_alert_tags_actions.useAlertTagsActions)({
    closePopover: closePopoverHandler,
    ecsRowData: ecsData !== null && ecsData !== void 0 ? ecsData : {
      _id: actionsData.eventId
    },
    refetch
  });
  const {
    investigateInTimelineActionItems
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)({
    ecsRowData: ecsData,
    onInvestigateInTimelineAlertClick: closePopoverHandler
  });
  const osqueryAvailable = osquery === null || osquery === void 0 ? void 0 : osquery.isOsqueryAvailable({
    agentId
  });
  const handleOnOsqueryClick = (0, _react.useCallback)(() => {
    onOsqueryClick(agentId);
    setIsPopoverOpen(false);
  }, [onOsqueryClick, setIsPopoverOpen, agentId]);
  const osqueryActionItem = (0, _react.useMemo)(() => (0, _osquery_action_item.getOsqueryActionItem)({
    handleClick: handleOnOsqueryClick
  }), [handleOnOsqueryClick]);
  const alertsActionItems = (0, _react.useMemo)(() => !isEvent && actionsData.ruleId ? [...statusActionItems, ...alertTagsItems, ...exceptionActionItems] : isEndpointEvent && canCreateEndpointEventFilters ? eventFilterActionItems : [], [eventFilterActionItems, isEndpointEvent, canCreateEndpointEventFilters, exceptionActionItems, statusActionItems, isEvent, actionsData.ruleId, alertTagsItems]);
  const isInDetections = [_securitysolutionDataTable.TableId.alertsOnAlertsPage, _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage].includes(scopeId);
  const {
    addToCaseActionItems,
    handleAddToNewCaseClick
  } = (0, _use_add_to_case_actions.useAddToCaseActions)({
    ecsData,
    nonEcsData: (_detailsData$map = detailsData === null || detailsData === void 0 ? void 0 : detailsData.map(d => ({
      field: d.field,
      value: d.values
    }))) !== null && _detailsData$map !== void 0 ? _detailsData$map : [],
    onMenuItemClick,
    onSuccess: refetchFlyoutData,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId),
    isInDetections,
    refetch
  });
  const items = (0, _react.useMemo)(() => [...(tGridEnabled ? addToCaseActionItems : []), ...alertsActionItems, ...hostIsolationActionItems, ...endpointResponseActionsConsoleItems, ...(osqueryAvailable ? [osqueryActionItem] : []), ...investigateInTimelineActionItems], [tGridEnabled, addToCaseActionItems, alertsActionItems, hostIsolationActionItems, endpointResponseActionsConsoleItems, osqueryAvailable, osqueryActionItem, investigateInTimelineActionItems]);
  const panels = [{
    id: 0,
    items
  }, ...alertTagsPanels];
  const takeActionButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_tour_step.GuidedOnboardingTourStep, {
    onClick: handleAddToNewCaseClick,
    step: _tour_config.AlertsCasesTourSteps.addAlertToCase,
    tourId: _tour_config.SecurityStepId.alertsCases
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "take-action-dropdown-btn",
    fill: true,
    iconSide: "right",
    iconType: "arrowDown",
    onClick: togglePopoverHandler
  }, _translations.TAKE_ACTION)), [handleAddToNewCaseClick, togglePopoverHandler]);
  return items.length && !loadingEventDetails && ecsData ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "AlertTakeActionPanel",
    button: takeActionButton,
    isOpen: isPopoverOpen,
    closePopover: closePopoverHandler,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    size: "s",
    initialPanelId: 0,
    panels: panels,
    "data-test-subj": "takeActionPanelMenu"
  })) : null;
});
exports.TakeActionDropdown = TakeActionDropdown;