"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewHistogram = exports.ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/data-plugin/common");
var _esQuery = require("@kbn/es-query");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _events_viewer = require("../../../../common/components/events_viewer");
var _renderers = require("../../../../timelines/components/timeline/body/renderers");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_global_time = require("../../../../common/containers/use_global_time");
var _helpers = require("./helpers");
var _panel = require("../../../../common/components/panel");
var _header_section = require("../../../../common/components/header_section");
var _barchart = require("../../../../common/components/charts/barchart");
var _use_preview_histogram = require("./use_preview_histogram");
var _default_config = require("../../alerts_table/default_config");
var _model = require("../../../../common/store/sourcerer/model");
var _constants = require("../../../../../common/constants");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _side_panel = require("../../../../timelines/components/side_panel");
var _preview_table_cell_renderer = require("./preview_table_cell_renderer");
var _preview_table_control_columns = require("./preview_table_control_columns");
var _use_full_screen = require("../../../../common/containers/use_full_screen");
var _use_license = require("../../../../common/hooks/use_license");
var _kibana = require("../../../../common/lib/kibana");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _rule_preview = require("../../../../common/components/visualization_actions/lens_attributes/common/alerts/rule_preview");
var _visualization_embeddable = require("../../../../common/components/visualization_actions/visualization_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LoadingChart = (0, _styledComponents.default)(_eui.EuiLoadingChart)`
  display: block;
  margin: 0 auto;
`;
const FullScreenContainer = _styledComponents.default.div`
  height: ${({
  $isFullScreen
}) => $isFullScreen ? '100%' : undefined};
  flex: 1 1 auto;
  display: flex;
  width: 100%;
`;
const ID = 'previewHistogram';
exports.ID = ID;
const CHART_HEIGHT = 150;
const DEFAULT_HISTOGRAM_HEIGHT = 300;
const PreviewHistogram = ({
  previewId,
  addNoiseWarning,
  spaceId,
  ruleType,
  indexPattern,
  timeframeOptions
}) => {
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const {
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const startDate = (0, _react.useMemo)(() => timeframeOptions.timeframeStart.toISOString(), [timeframeOptions]);
  const endDate = (0, _react.useMemo)(() => timeframeOptions.timeframeEnd.toISOString(), [timeframeOptions]);
  // It seems like the Table/Grid component uses end date value as a non-inclusive one,
  // thus the alerts which have timestamp equal to the end date value are not displayed in the table.
  // To fix that, we extend end date value by 1s to make sure all alerts are included in the table.
  const extendedEndDate = (0, _react.useMemo)(() => timeframeOptions.timeframeEnd.clone().add('1', 's').toISOString(), [timeframeOptions]);
  const isEqlRule = (0, _react.useMemo)(() => ruleType === 'eql', [ruleType]);
  const isMlRule = (0, _react.useMemo)(() => ruleType === 'machine_learning', [ruleType]);
  const isAlertsPreviewChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('alertsPreviewChartEmbeddablesEnabled');
  const timerange = (0, _react.useMemo)(() => ({
    from: startDate,
    to: endDate
  }), [startDate, endDate]);
  const extraVisualizationOptions = (0, _react.useMemo)(() => ({
    ruleId: previewId,
    spaceId
  }), [previewId, spaceId]);
  const [isLoading, {
    data,
    inspect,
    totalCount,
    refetch
  }] = (0, _use_preview_histogram.usePreviewHistogram)({
    previewId,
    startDate,
    endDate,
    spaceId,
    indexPattern,
    ruleType,
    skip: isAlertsPreviewChartEmbeddablesEnabled
  });
  const license = (0, _use_license.useLicense)();
  const {
    browserFields,
    runtimeMappings
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const previousPreviewId = (0, _usePrevious.default)(previewId);
  const previewQueryId = `${ID}-${previewId}`;
  (0, _react.useEffect)(() => {
    if (previousPreviewId !== previewId && totalCount > 0) {
      if ((0, _helpers.isNoisy)(totalCount, timeframeOptions)) {
        addNoiseWarning();
      }
    }
  }, [totalCount, addNoiseWarning, previousPreviewId, previewId, timeframeOptions]);
  (0, _react.useEffect)(() => {
    if (!isLoading && !isInitializing) {
      setQuery({
        id: previewQueryId,
        inspect,
        loading: isLoading,
        refetch
      });
    }
  }, [setQuery, inspect, isLoading, isInitializing, refetch, previewId, isAlertsPreviewChartEmbeddablesEnabled, previewQueryId]);
  const barConfig = (0, _react.useMemo)(() => (0, _helpers.getHistogramConfig)(endDate, startDate, !isEqlRule), [endDate, startDate, isEqlRule]);
  const chartData = (0, _react.useMemo)(() => [{
    key: 'hits',
    value: data
  }], [data]);
  const config = (0, _common.getEsQueryConfig)(uiSettings);
  const pageFilters = (0, _react.useMemo)(() => {
    const filterQuery = (0, _esQuery.buildEsQuery)(indexPattern, [{
      query: `kibana.alert.rule.uuid:${previewId}`,
      language: 'kuery'
    }], [], {
      nestedIgnoreUnmapped: true,
      ...config,
      dateFormatTZ: undefined
    });
    return [{
      ...filterQuery,
      meta: {
        alias: null,
        negate: false,
        disabled: false,
        type: 'phrase',
        key: 'kibana.alert.rule.uuid',
        params: {
          query: previewId
        }
      }
    }];
  }, [config, indexPattern, previewId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    height: DEFAULT_HISTOGRAM_HEIGHT,
    "data-test-subj": 'preview-histogram-panel'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: previewQueryId,
    title: i18n.QUERY_GRAPH_HITS_TITLE,
    titleSize: "xs",
    showInspectButton: !isAlertsPreviewChartEmbeddablesEnabled
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, isLoading ? /*#__PURE__*/_react.default.createElement(LoadingChart, {
    size: "l",
    "data-test-subj": "preview-histogram-loading"
  }) : isAlertsPreviewChartEmbeddablesEnabled ? /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: false,
    extraOptions: extraVisualizationOptions,
    getLensAttributes: _rule_preview.getRulePreviewLensAttributes,
    height: CHART_HEIGHT,
    id: `${previewQueryId}-embeddable`,
    inspectTitle: i18n.QUERY_GRAPH_HITS_TITLE,
    scopeId: _model.SourcererScopeName.detections,
    stackByField: ruleType === 'machine_learning' ? 'host.name' : 'event.category',
    timerange: timerange,
    withActions: false
  }) : /*#__PURE__*/_react.default.createElement(_barchart.BarChart, {
    configs: barConfig,
    barChart: chartData,
    "data-test-subj": "preview-histogram-bar-chart"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, isMlRule ? i18n.ML_PREVIEW_HISTOGRAM_DISCLAIMER : i18n.PREVIEW_HISTOGRAM_DISCLAIMER)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(FullScreenContainer, {
    $isFullScreen: globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_events_viewer.StatefulEventsViewer, {
    pageFilters: pageFilters,
    defaultModel: (0, _default_config.getAlertsPreviewDefaultModel)(license),
    end: extendedEndDate,
    tableId: _securitysolutionDataTable.TableId.rulePreview,
    leadingControlColumns: (0, _preview_table_control_columns.getPreviewTableControlColumn)(1.5),
    renderCellValue: _preview_table_cell_renderer.PreviewRenderCellValue,
    rowRenderers: _renderers.defaultRowRenderers,
    start: startDate,
    sourcererScope: _model.SourcererScopeName.detections,
    indexNames: [`${_constants.DEFAULT_PREVIEW_INDEX}-${spaceId}`],
    bulkActions: false
  })), /*#__PURE__*/_react.default.createElement(_side_panel.DetailsPanel, {
    browserFields: browserFields,
    isFlyoutView: true,
    runtimeMappings: runtimeMappings,
    scopeId: _securitysolutionDataTable.TableId.rulePreview,
    isReadOnly: true
  }));
};
exports.PreviewHistogram = PreviewHistogram;