"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInstalledIntegrations = void 0;
var _reactQuery = require("@tanstack/react-query");
var _fleet_integrations = require("../../../../detection_engine/fleet_integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// import { useAppToasts } from '../../../../common/hooks/use_app_toasts';
// import * as i18n from './translations';

const ONE_MINUTE = 60000;
const useInstalledIntegrations = ({
  packages
}) => {
  // const { addError } = useAppToasts();

  return (0, _reactQuery.useQuery)(['installedIntegrations', {
    packages
  }], async ({
    signal
  }) => {
    var _integrations$install;
    const integrations = await _fleet_integrations.fleetIntegrationsApi.fetchInstalledIntegrations({
      packages,
      signal
    });
    return (_integrations$install = integrations.installed_integrations) !== null && _integrations$install !== void 0 ? _integrations$install : [];
  }, {
    keepPreviousData: true,
    staleTime: ONE_MINUTE * 5,
    onError: e => {
      // Suppressing for now to prevent excessive errors when fleet isn't configured
      // addError(e, { title: i18n.INTEGRATIONS_FETCH_FAILURE });
    }
  });
};
exports.useInstalledIntegrations = useInstalledIntegrations;