"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddElasticRulesButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _rules_management_tour = require("../../../../detection_engine/rule_management_ui/components/rules_table/rules_table/guided_onboarding/rules_management_tour");
var i18n = _interopRequireWildcard(require("./translations"));
var _links = require("../../../../common/components/links");
var _common = require("../../../../../common");
var _use_prebuilt_rules_status = require("../../../../detection_engine/rule_management/logic/prebuilt_rules/use_prebuilt_rules_status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddElasticRulesButton = ({
  'data-test-subj': dataTestSubj = 'addElasticRulesButton',
  fill,
  isDisabled,
  showBadge = true
}) => {
  var _preBuiltRulesStatus$;
  const getSecuritySolutionLinkProps = (0, _links.useGetSecuritySolutionLinkProps)();
  const {
    onClick: onClickLink
  } = getSecuritySolutionLinkProps({
    deepLinkId: _common.SecurityPageName.rulesAdd
  });
  const {
    data: preBuiltRulesStatus
  } = (0, _use_prebuilt_rules_status.usePrebuiltRulesStatus)();
  const newRulesCount = (_preBuiltRulesStatus$ = preBuiltRulesStatus === null || preBuiltRulesStatus === void 0 ? void 0 : preBuiltRulesStatus.num_prebuilt_rules_to_install) !== null && _preBuiltRulesStatus$ !== void 0 ? _preBuiltRulesStatus$ : 0;
  const ButtonComponent = fill ? _eui.EuiButton : _eui.EuiButtonEmpty;
  return /*#__PURE__*/_react.default.createElement(ButtonComponent, {
    id: _rules_management_tour.INSTALL_PREBUILT_RULES_ANCHOR,
    fill: fill,
    iconType: "plusInCircle",
    color: 'primary',
    onClick: onClickLink,
    "data-test-subj": dataTestSubj,
    isDisabled: isDisabled
  }, i18n.ADD_ELASTIC_RULES, newRulesCount > 0 && showBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: '#E0E5EE',
    css: (0, _react2.css)`
            margin-left: 5px;
          `
  }, newRulesCount));
};
exports.AddElasticRulesButton = AddElasticRulesButton;