"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByFields = exports.GroupByComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD_COMBO_BOX_WIDTH = 410;
const fieldDescribedByIds = 'detectionEngineStepDefineRuleGroupByField';
const GroupByComponent = ({
  browserFields,
  isDisabled,
  field
}) => {
  const fieldEuiFieldProps = (0, _react.useMemo)(() => ({
    fullWidth: true,
    noSuggestions: false,
    options: browserFields.map(browserField => ({
      label: browserField.name
    })),
    placeholder: _translations.GROUP_BY_FIELD_PLACEHOLDER,
    onCreateOption: undefined,
    style: {
      width: `${FIELD_COMBO_BOX_WIDTH}px`
    },
    isDisabled
  }), [browserFields, isDisabled]);
  const fieldComponent = /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
    field: field,
    idAria: fieldDescribedByIds,
    euiFieldProps: fieldEuiFieldProps
  });
  return isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: _translations.GROUP_BY_FIELD_LICENSE_WARNING
  }, fieldComponent) : fieldComponent;
};
exports.GroupByComponent = GroupByComponent;
const GroupByFields = /*#__PURE__*/_react.default.memo(GroupByComponent);
exports.GroupByFields = GroupByFields;