"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutocompleteField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionAutocomplete = require("@kbn/securitysolution-autocomplete");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutocompleteField = ({
  dataTestSubj,
  field,
  idAria,
  indices,
  isDisabled,
  fieldType,
  placeholder
}) => {
  const handleFieldChange = (0, _react.useCallback)(([newField]) => {
    var _newField$name;
    // TODO: Update onChange type in FieldComponent as newField can be undefined
    field.setValue((_newField$name = newField === null || newField === void 0 ? void 0 : newField.name) !== null && _newField$name !== void 0 ? _newField$name : '');
  }, [field]);
  const selectedField = (0, _react.useMemo)(() => {
    var _ref;
    const existingField = (_ref = field.value) !== null && _ref !== void 0 ? _ref : '';
    const [newSelectedField] = indices.fields.filter(({
      name
    }) => existingField != null && existingField === name);
    return newSelectedField;
  }, [field.value, indices]);
  const fieldTypeFilter = (0, _react.useMemo)(() => [fieldType], [fieldType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    fullWidth: true,
    helpText: field.helpText,
    label: field.label,
    labelAppend: field.labelAppend
  }, /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.FieldComponent, {
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : '',
    indexPattern: indices,
    selectedField: selectedField,
    fieldTypeFilter: fieldTypeFilter,
    isLoading: false,
    isDisabled: isDisabled,
    isClearable: false,
    onChange: handleFieldChange,
    "data-test-subj": dataTestSubj,
    "aria-label": idAria,
    fieldInputWidth: 500
  }));
};
exports.AutocompleteField = AutocompleteField;