"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsActions = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _use_bulk_action_items = require("../../../../common/components/toolbar/bulk_actions/use_bulk_action_items");
var _helpers = require("../../../../helpers");
var _use_alerts_privileges = require("../../../containers/detection_engine/alerts/use_alerts_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertsActions = ({
  alertStatus,
  closePopover,
  eventId,
  scopeId,
  indexName,
  refetch
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    hasIndexWrite
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const onStatusUpdate = (0, _react.useCallback)(() => {
    closePopover();
    if (refetch) {
      refetch();
    }
  }, [closePopover, refetch]);
  const scopedActions = (0, _helpers.getScopedActions)(scopeId);
  const localSetEventsLoading = (0, _react.useCallback)(({
    eventIds,
    isLoading
  }) => {
    if (scopedActions) {
      dispatch(scopedActions.setEventsLoading({
        id: scopeId,
        eventIds,
        isLoading
      }));
    }
  }, [dispatch, scopeId, scopedActions]);
  const setEventsDeleted = (0, _react.useCallback)(({
    eventIds,
    isDeleted
  }) => {
    if (scopedActions) {
      dispatch(scopedActions.setEventsDeleted({
        id: scopeId,
        eventIds,
        isDeleted
      }));
    }
  }, [dispatch, scopeId, scopedActions]);
  const actionItems = (0, _use_bulk_action_items.useBulkActionItems)({
    eventIds: [eventId],
    currentStatus: alertStatus,
    indexName,
    setEventsLoading: localSetEventsLoading,
    setEventsDeleted,
    onUpdateSuccess: onStatusUpdate,
    onUpdateFailure: onStatusUpdate
  });
  return {
    actionItems: hasIndexWrite ? actionItems : []
  };
};
exports.useAlertsActions = useAlertsActions;