"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LEGEND_WITH_COUNTS_WIDTH = exports.DETECTIONS_HISTOGRAM_ID = exports.AlertsHistogramPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fp = require("lodash/fp");
var _uuid = require("uuid");
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/data-plugin/common");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _constants = require("../../../../../common/constants");
var _helpers = require("../../../../common/components/drag_and_drop/helpers");
var _header_section = require("../../../../common/components/header_section");
var _use_query = require("../../../containers/detection_engine/alerts/use_query");
var _constants2 = require("../../../containers/detection_engine/alerts/constants");
var _link_to = require("../../../../common/components/link_to");
var _utils = require("../../../../common/components/matrix_histogram/utils");
var _inspect = require("../../../../common/components/inspect");
var _matrix_loader = require("../../../../common/components/matrix_histogram/matrix_loader");
var _kibana = require("../../../../common/lib/kibana");
var _helpers2 = require("./helpers");
var _alerts_histogram = require("./alerts_histogram");
var i18n = _interopRequireWildcard(require("./translations"));
var _links = require("../../../../common/components/links");
var _types = require("../../../../app/types");
var _config = require("../common/config");
var _components = require("../common/components");
var _hooks = require("../common/hooks");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _translations2 = require("../common/translations");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _alerts_histogram2 = require("../../../../common/components/visualization_actions/lens_attributes/common/alerts/alerts_histogram");
var _model = require("../../../../common/store/sourcerer/model");
var _visualization_embeddable = require("../../../../common/components/visualization_actions/visualization_embeddable");
var _use_alert_histogram_count = require("../../../hooks/alerts_visualization/use_alert_histogram_count");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultTotalAlertsObj = {
  value: 0,
  relation: 'eq'
};
const DETECTIONS_HISTOGRAM_ID = 'detections-histogram';
exports.DETECTIONS_HISTOGRAM_ID = DETECTIONS_HISTOGRAM_ID;
const ViewAlertsFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeL};
`;
const OptionsFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const LEGEND_WITH_COUNTS_WIDTH = 300; // px
exports.LEGEND_WITH_COUNTS_WIDTH = LEGEND_WITH_COUNTS_WIDTH;
const CHART_HEIGHT = 155; // px

const NO_LEGEND_DATA = [];
const AlertsHistogramPanel = /*#__PURE__*/(0, _react.memo)(({
  alignHeader,
  chartHeight = CHART_HEIGHT,
  chartOptionsContextMenu,
  combinedQueries,
  comboboxRef,
  defaultStackByOption = _config.DEFAULT_STACK_BY_FIELD,
  extraActions,
  filters,
  headerChildren,
  inspectTitle,
  legendPosition = 'right',
  onFieldSelected,
  onlyField,
  paddingSize = 'm',
  panelHeight = _config.PANEL_HEIGHT,
  query,
  runtimeMappings,
  setComboboxInputRef,
  showCountsInLegend = false,
  showGroupByPlaceholder = false,
  showLegend = true,
  showLinkToAlerts = false,
  showStackBy = true,
  showTotalAlertsCount = false,
  signalIndexName,
  stackByLabel,
  stackByWidth,
  timelineId,
  title = i18n.HISTOGRAM_HEADER,
  titleSize = 'm',
  updateDateRange,
  hideQueryToggle = false,
  isExpanded,
  setIsExpanded
}) => {
  var _alertsData$aggregati3;
  const {
    to,
    from,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();

  // create a unique, but stable (across re-renders) query id
  const uniqueQueryId = (0, _react.useMemo)(() => `${DETECTIONS_HISTOGRAM_ID}-${(0, _uuid.v4)()}`, []);
  const visualizationId = `alerts-trend-embeddable-${uniqueQueryId}`;
  const [isInitialLoading, setIsInitialLoading] = (0, _react.useState)(true);
  const [isInspectDisabled, setIsInspectDisabled] = (0, _react.useState)(false);
  const [totalAlertsObj, setTotalAlertsObj] = (0, _react.useState)(defaultTotalAlertsObj);
  const [selectedStackByOption, setSelectedStackByOption] = (0, _react.useState)(onlyField == null ? defaultStackByOption : onlyField);
  const isChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('chartEmbeddablesEnabled');
  const isAlertsPageChartsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('alertsPageChartsEnabled');
  const onSelect = (0, _react.useCallback)(field => {
    setSelectedStackByOption(field);
    if (onFieldSelected != null) {
      onFieldSelected(field);
    }
  }, [onFieldSelected]);
  (0, _react.useEffect)(() => {
    setSelectedStackByOption(onlyField == null ? defaultStackByOption : onlyField);
  }, [defaultStackByOption, onlyField]);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(DETECTIONS_HISTOGRAM_ID);
  const toggleQuery = (0, _react.useCallback)(newToggleStatus => {
    if (isAlertsPageChartsEnabled && setIsExpanded !== undefined) {
      setIsExpanded(newToggleStatus);
    } else {
      setToggleStatus(newToggleStatus);
    }
  }, [setToggleStatus, setIsExpanded, isAlertsPageChartsEnabled]);
  const querySkip = (0, _react.useMemo)(() => isAlertsPageChartsEnabled && setIsExpanded !== undefined ? !isExpanded : !toggleStatus, [isAlertsPageChartsEnabled, setIsExpanded, isExpanded, toggleStatus]);
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const {
    loading: isLoadingAlerts,
    data: alertsData,
    setQuery: setAlertsQuery,
    response,
    request,
    refetch
  } = (0, _use_query.useQueryAlerts)({
    query: (0, _helpers2.getAlertsHistogramQuery)(selectedStackByOption, from, to, (0, _helpers2.buildCombinedQueries)(combinedQueries), runtimeMappings),
    indexName: signalIndexName,
    skip: querySkip || isChartEmbeddablesEnabled,
    queryName: _constants2.ALERTS_QUERY_NAMES.HISTOGRAM
  });
  const kibana = (0, _kibana.useKibana)();
  const {
    navigateToApp
  } = kibana.services.application;
  const {
    formatUrl,
    search: urlSearch
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.alerts);
  const totalAlerts = (0, _use_alert_histogram_count.useAlertHistogramCount)({
    totalAlertsObj,
    visualizationId,
    isChartEmbeddablesEnabled
  });
  const goToDetectionEngine = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.alerts,
      path: (0, _link_to.getDetectionEngineUrl)(urlSearch)
    });
  }, [navigateToApp, urlSearch]);
  const formattedAlertsData = (0, _react.useMemo)(() => (0, _helpers2.formatAlertsData)(alertsData), [alertsData]);
  const legendItems = (0, _react.useMemo)(() => {
    var _alertsData$aggregati, _alertsData$aggregati2;
    return showLegend && (alertsData === null || alertsData === void 0 ? void 0 : (_alertsData$aggregati = alertsData.aggregations) === null || _alertsData$aggregati === void 0 ? void 0 : (_alertsData$aggregati2 = _alertsData$aggregati.alertsByGrouping) === null || _alertsData$aggregati2 === void 0 ? void 0 : _alertsData$aggregati2.buckets) != null ? alertsData.aggregations.alertsByGrouping.buckets.map((bucket, i) => {
      var _bucket$key_as_string;
      return {
        color: i < _utils.defaultLegendColors.length ? _utils.defaultLegendColors[i] : undefined,
        count: showCountsInLegend ? bucket.doc_count : undefined,
        dataProviderId: (0, _helpers.escapeDataProviderId)(`draggable-legend-item-${(0, _uuid.v4)()}-${selectedStackByOption}-${bucket.key}`),
        field: selectedStackByOption,
        timelineId,
        value: (_bucket$key_as_string = bucket === null || bucket === void 0 ? void 0 : bucket.key_as_string) !== null && _bucket$key_as_string !== void 0 ? _bucket$key_as_string : bucket.key
      };
    }) : NO_LEGEND_DATA;
  }, [alertsData === null || alertsData === void 0 ? void 0 : (_alertsData$aggregati3 = alertsData.aggregations) === null || _alertsData$aggregati3 === void 0 ? void 0 : _alertsData$aggregati3.alertsByGrouping.buckets, selectedStackByOption, showCountsInLegend, showLegend, timelineId]);
  (0, _react.useEffect)(() => {
    let canceled = false;
    if (!canceled && !(0, _helpers2.showInitialLoadingSpinner)({
      isInitialLoading,
      isLoadingAlerts
    })) {
      setIsInitialLoading(false);
    }
    return () => {
      canceled = true; // prevent long running data fetches from updating state after unmounting
    };
  }, [isInitialLoading, isLoadingAlerts, setIsInitialLoading]);
  (0, _hooks.useInspectButton)({
    deleteQuery,
    loading: isLoadingAlerts,
    refetch,
    request,
    response,
    setQuery,
    uniqueQueryId
  });
  (0, _react.useEffect)(() => {
    var _alertsData$hits$tota;
    setTotalAlertsObj((_alertsData$hits$tota = alertsData === null || alertsData === void 0 ? void 0 : alertsData.hits.total) !== null && _alertsData$hits$tota !== void 0 ? _alertsData$hits$tota : {
      value: 0,
      relation: 'eq'
    });
  }, [alertsData]);
  (0, _react.useEffect)(() => {
    try {
      let converted = null;
      if (combinedQueries != null) {
        converted = (0, _helpers2.parseCombinedQueries)(combinedQueries);
      } else {
        var _filters$filter;
        converted = (0, _esQuery.buildEsQuery)(undefined, query != null ? [query] : [], (_filters$filter = filters === null || filters === void 0 ? void 0 : filters.filter(f => f.meta.disabled === false)) !== null && _filters$filter !== void 0 ? _filters$filter : [], {
          ...(0, _common.getEsQueryConfig)(kibana.services.uiSettings),
          dateFormatTZ: undefined
        });
      }
      setIsInspectDisabled(false);
      setAlertsQuery((0, _helpers2.getAlertsHistogramQuery)(selectedStackByOption, from, to, !(0, _fp.isEmpty)(converted) ? [converted] : [], runtimeMappings));
    } catch (e) {
      setIsInspectDisabled(true);
      setAlertsQuery((0, _helpers2.getAlertsHistogramQuery)(selectedStackByOption, from, to, [], runtimeMappings));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedStackByOption, from, to, query, filters, combinedQueries, runtimeMappings]);
  const linkButton = (0, _react.useMemo)(() => {
    if (showLinkToAlerts) {
      return /*#__PURE__*/_react.default.createElement(ViewAlertsFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
        "data-test-subj": "alerts-histogram-panel-go-to-alerts-page",
        onClick: goToDetectionEngine,
        href: formatUrl((0, _link_to.getDetectionEngineUrl)())
      }, i18n.VIEW_ALERTS));
    }
  }, [showLinkToAlerts, goToDetectionEngine, formatUrl]);
  const titleText = (0, _react.useMemo)(() => onlyField == null ? title : i18n.TOP(onlyField), [onlyField, title]);
  const showHistogram = (0, _react.useMemo)(() => {
    if (isAlertsPageChartsEnabled) {
      if (isExpanded !== undefined) {
        // alerts page
        return isExpanded;
      } else {
        // rule details page and overview page
        return toggleStatus;
      }
    } else {
      return toggleStatus;
    }
  }, [isAlertsPageChartsEnabled, isExpanded, toggleStatus]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    show: !isInitialLoading && showHistogram
  }, /*#__PURE__*/_react.default.createElement(_components.KpiPanel, {
    height: panelHeight,
    hasBorder: true,
    paddingSize: paddingSize,
    "data-test-subj": "alerts-histogram-panel",
    $toggleStatus: showHistogram
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    alignHeader: alignHeader,
    id: uniqueQueryId,
    inspectTitle: inspectTitle,
    outerDirection: "column",
    title: titleText,
    titleSize: titleSize,
    toggleStatus: showHistogram,
    toggleQuery: hideQueryToggle ? undefined : toggleQuery,
    showInspectButton: isChartEmbeddablesEnabled ? false : chartOptionsContextMenu == null,
    subtitle: !isInitialLoading && showTotalAlertsCount && totalAlerts,
    isInspectDisabled: isInspectDisabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    "data-test-subj": "panelFlexGroup",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, showStackBy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.StackByComboBox, {
    "data-test-subj": "stackByComboBox",
    inputRef: setComboboxInputRef,
    onSelect: onSelect,
    prepend: stackByLabel,
    ref: comboboxRef,
    selected: selectedStackByOption,
    useLensCompatibleFields: isChartEmbeddablesEnabled,
    width: stackByWidth
  }), showGroupByPlaceholder && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    "data-test-subj": "placeholderSpacer",
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "placeholderTooltip",
    content: i18n.NOT_AVAILABLE_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_components.StackByComboBox, {
    "data-test-subj": "stackByPlaceholder",
    isDisabled: true,
    onSelect: _fp.noop,
    prepend: _translations2.GROUP_BY_TOP_LABEL,
    selected: "",
    useLensCompatibleFields: isChartEmbeddablesEnabled,
    width: stackByWidth
  })))), headerChildren != null && headerChildren), chartOptionsContextMenu != null && !isChartEmbeddablesEnabled && /*#__PURE__*/_react.default.createElement(OptionsFlexItem, {
    grow: false
  }, chartOptionsContextMenu(uniqueQueryId)), linkButton)), showHistogram ? isChartEmbeddablesEnabled ? /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-matrix-histogram",
    extraActions: extraActions,
    extraOptions: {
      filters
    },
    getLensAttributes: _alerts_histogram2.getAlertsHistogramLensAttributes,
    height: chartHeight !== null && chartHeight !== void 0 ? chartHeight : CHART_HEIGHT,
    id: visualizationId,
    inspectTitle: inspectTitle !== null && inspectTitle !== void 0 ? inspectTitle : title,
    scopeId: _model.SourcererScopeName.detections,
    stackByField: selectedStackByOption,
    timerange: timerange
  }) : isInitialLoading ? /*#__PURE__*/_react.default.createElement(_matrix_loader.MatrixLoader, null) : /*#__PURE__*/_react.default.createElement(_alerts_histogram.AlertsHistogram, {
    chartHeight: chartHeight,
    data: formattedAlertsData,
    from: from,
    legendItems: legendItems,
    legendPosition: legendPosition,
    legendMinWidth: showCountsInLegend ? LEGEND_WITH_COUNTS_WIDTH : undefined,
    loading: isLoadingAlerts,
    to: to,
    showLegend: showLegend,
    updateDateRange: updateDateRange
  }) : null));
});
exports.AlertsHistogramPanel = AlertsHistogramPanel;
AlertsHistogramPanel.displayName = 'AlertsHistogramPanel';