"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showInitialLoadingSpinner = exports.parseCombinedQueries = exports.getAlertsHistogramQuery = exports.formatAlertsData = exports.createResetGroupByFieldAction = exports.buildCombinedQueries = void 0;
var _fp = require("lodash/fp");
var _moment = _interopRequireDefault(require("moment"));
var _translations = require("../../../../common/components/chart_settings_popover/configurations/default/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_ALERTS_DATA = [];
const formatAlertsData = alertsData => {
  var _alertsData$aggregati, _alertsData$aggregati2, _alertsData$aggregati3;
  const groupBuckets = (_alertsData$aggregati = alertsData === null || alertsData === void 0 ? void 0 : (_alertsData$aggregati2 = alertsData.aggregations) === null || _alertsData$aggregati2 === void 0 ? void 0 : (_alertsData$aggregati3 = _alertsData$aggregati2.alertsByGrouping) === null || _alertsData$aggregati3 === void 0 ? void 0 : _alertsData$aggregati3.buckets) !== null && _alertsData$aggregati !== void 0 ? _alertsData$aggregati : [];
  return groupBuckets.reduce((acc, {
    key_as_string: keyAsString,
    key: group,
    alerts
  }) => {
    var _alerts$buckets;
    const alertsBucket = (_alerts$buckets = alerts.buckets) !== null && _alerts$buckets !== void 0 ? _alerts$buckets : [];
    return [...acc,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    ...alertsBucket.map(({
      key,
      doc_count
    }) => ({
      x: key,
      y: doc_count,
      g: keyAsString !== null && keyAsString !== void 0 ? keyAsString : group.toString()
    }))];
  }, EMPTY_ALERTS_DATA);
};
exports.formatAlertsData = formatAlertsData;
const getAlertsHistogramQuery = (stackByField, from, to, additionalFilters, runtimeMappings) => {
  return {
    aggs: {
      alertsByGrouping: {
        terms: {
          field: stackByField,
          order: {
            _count: 'desc'
          },
          size: 10
        },
        aggs: {
          alerts: {
            date_histogram: {
              field: '@timestamp',
              fixed_interval: `${Math.floor((0, _moment.default)(to).diff((0, _moment.default)(from)) / 32)}ms`,
              min_doc_count: 0,
              extended_bounds: {
                min: from,
                max: to
              }
            }
          }
        }
      }
    },
    query: {
      bool: {
        filter: [...additionalFilters, {
          range: {
            '@timestamp': {
              gte: from,
              lte: to
            }
          }
        }]
      }
    },
    runtime_mappings: runtimeMappings,
    _source: false,
    size: 0
  };
};

/**
 * Returns `true` when the alerts histogram initial loading spinner should be shown
 *
 * @param isInitialLoading The loading spinner will only be displayed if this value is `true`, because after initial load, a different, non-spinner loading indicator is displayed
 * @param isLoadingAlerts When `true`, IO is being performed to request alerts (for rendering in the histogram)
 */
exports.getAlertsHistogramQuery = getAlertsHistogramQuery;
const showInitialLoadingSpinner = ({
  isInitialLoading,
  isLoadingAlerts
}) => isInitialLoading && isLoadingAlerts;
exports.showInitialLoadingSpinner = showInitialLoadingSpinner;
const parseCombinedQueries = query => {
  try {
    return query != null && !(0, _fp.isEmpty)(query) ? JSON.parse(query) : {};
  } catch {
    return {};
  }
};
exports.parseCombinedQueries = parseCombinedQueries;
const buildCombinedQueries = query => {
  try {
    return (0, _fp.isEmpty)(query) ? [] : [parseCombinedQueries(query)];
  } catch {
    return [];
  }
};
exports.buildCombinedQueries = buildCombinedQueries;
const createResetGroupByFieldAction = ({
  callback,
  order
} = {}) => ({
  id: 'resetGroupByField',
  getDisplayName() {
    return _translations.RESET_GROUP_BY_FIELDS;
  },
  getIconType() {
    return 'editorRedo';
  },
  type: 'actionButton',
  async isCompatible() {
    return true;
  },
  async execute({
    embeddable
  }) {
    callback === null || callback === void 0 ? void 0 : callback();
    const input = embeddable.getInput();
    const {
      attributes: {
        state: {
          visualization: {
            columns
          }
        }
      }
    } = input;

    // Unhide all the columns
    embeddable.updateInput({
      ...input,
      attributes: {
        ...input.attributes,
        state: {
          ...input.attributes.state,
          visualization: {
            ...input.attributes.state.visualization,
            columns: columns.map(c => ({
              ...c,
              hidden: false
            }))
          }
        }
      }
    });
  },
  order
});
exports.createResetGroupByFieldAction = createResetGroupByFieldAction;