"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseAlertsTypeData = exports.parseAlertsRuleData = exports.getIsAlertsTypeData = exports.getIsAlertsByTypeAgg = exports.getIsAlertsByRuleAgg = exports.ALERT_TYPE_LABEL = exports.ALERT_TYPE_COLOR = void 0;
var _lodash = require("lodash");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_TYPE_COLOR = {
  Detection: '#D36086',
  Prevention: '#54B399'
};
exports.ALERT_TYPE_COLOR = ALERT_TYPE_COLOR;
const ALERT_TYPE_LABEL = {
  Detection: _translations.DETECTION,
  Prevention: _translations.PREVENTION
};
exports.ALERT_TYPE_LABEL = ALERT_TYPE_LABEL;
const parseAlertsRuleData = response => {
  var _response$aggregation, _response$aggregation2, _response$aggregation3;
  const rulesBuckets = (_response$aggregation = response === null || response === void 0 ? void 0 : (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.alertsByRule) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.buckets) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
  return rulesBuckets.length === 0 ? [] : rulesBuckets.map(rule => {
    return {
      rule: rule.key,
      type: 'Detection',
      value: rule.doc_count,
      color: ALERT_TYPE_COLOR.Detection
    };
  });
};
exports.parseAlertsRuleData = parseAlertsRuleData;
const parseAlertsTypeData = response => {
  var _response$aggregation4, _response$aggregation5, _response$aggregation6;
  const rulesBuckets = (_response$aggregation4 = response === null || response === void 0 ? void 0 : (_response$aggregation5 = response.aggregations) === null || _response$aggregation5 === void 0 ? void 0 : (_response$aggregation6 = _response$aggregation5.alertsByType) === null || _response$aggregation6 === void 0 ? void 0 : _response$aggregation6.buckets) !== null && _response$aggregation4 !== void 0 ? _response$aggregation4 : [];
  return rulesBuckets.length === 0 ? [] : rulesBuckets.flatMap(rule => {
    var _rule$ruleByEventType, _rule$ruleByEventType2;
    const events = (_rule$ruleByEventType = (_rule$ruleByEventType2 = rule.ruleByEventType) === null || _rule$ruleByEventType2 === void 0 ? void 0 : _rule$ruleByEventType2.buckets) !== null && _rule$ruleByEventType !== void 0 ? _rule$ruleByEventType : [];
    return getAlertType(rule.key, rule.doc_count, events);
  });
};
exports.parseAlertsTypeData = parseAlertsTypeData;
const getAlertType = (ruleName, ruleCount, ruleEvents) => {
  const preventions = ruleEvents.find(bucket => bucket.key === 'denied');
  if (!preventions) {
    return [{
      rule: ruleName,
      type: 'Detection',
      value: ruleCount,
      color: ALERT_TYPE_COLOR.Detection
    }];
  }
  const ret = [];
  if (preventions.doc_count < ruleCount) {
    ret.push({
      rule: ruleName,
      type: 'Detection',
      value: ruleCount - preventions.doc_count,
      color: ALERT_TYPE_COLOR.Detection
    });
  }
  ret.push({
    rule: ruleName,
    type: 'Prevention',
    value: preventions.doc_count,
    color: ALERT_TYPE_COLOR.Prevention
  });
  return ret;
};
const getIsAlertsTypeData = data => {
  return data === null || data === void 0 ? void 0 : data.every(x => (0, _lodash.has)(x, 'type'));
};
exports.getIsAlertsTypeData = getIsAlertsTypeData;
const getIsAlertsByTypeAgg = data => {
  return (0, _lodash.has)(data, 'aggregations.alertsByType');
};
exports.getIsAlertsByTypeAgg = getIsAlertsByTypeAgg;
const getIsAlertsByRuleAgg = data => {
  return (0, _lodash.has)(data, 'aggregations.alertsByRule');
};
exports.getIsAlertsByRuleAgg = getIsAlertsByRuleAgg;