"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsTypeTableColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _cell_actions = require("../../../../common/components/cell_actions");
var _draggables = require("../../../../common/components/draggables");
var _formatted_number = require("../../../../common/components/formatted_number");
var _translations = require("../../alerts_table/translations");
var _helpers = require("./helpers");
var _translations2 = require("../alerts_count_panel/translations");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsTypeTableColumns = isAlertTypeEnabled => [{
  field: 'rule',
  name: _translations.ALERTS_HEADERS_RULE_NAME,
  'data-test-subj': 'detectionsTable-rule',
  truncateText: true,
  render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    isDraggable: false,
    field: _ruleDataUtils.ALERT_RULE_NAME,
    hideTopN: true,
    id: `alert-detection-draggable-${rule}`,
    value: rule,
    queryValue: rule,
    tooltipContent: null,
    truncate: true
  }))
}, ...(isAlertTypeEnabled ? [{
  field: 'type',
  name: i18n.ALERTS_TYPE_COLUMN_TITLE,
  'data-test-subj': 'detectionsTable-type',
  truncateText: true,
  render: type => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: _helpers.ALERT_TYPE_COLOR[type]
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      mode: _cell_actions.CellActionsMode.HOVER_DOWN,
      visibleCellActions: 4,
      showActionTooltips: true,
      triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
      field: {
        name: 'event.type',
        value: 'denied',
        type: 'keyword'
      },
      metadata: {
        negateFilters: type === 'Detection'
      } // Detection: event.type != denied
    }, _helpers.ALERT_TYPE_LABEL[type])));
  },
  width: '30%'
}] : []), {
  field: 'value',
  name: _translations2.COUNT_TABLE_TITLE,
  dataType: 'number',
  sortable: true,
  'data-test-subj': 'detectionsTable-count',
  render: count => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count
  })),
  width: '22%'
}];
exports.getAlertsTypeTableColumns = getAlertsTypeTableColumns;