"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointActionText = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointActionTextComponent = ({
  name,
  isDisabled
}) => {
  const {
    title,
    description,
    tooltip
  } = useGetCommandText(name);
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, description));
  if (isDisabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: tooltip
    }, content);
  }
  return content;
};
const useGetCommandText = name => {
  switch (name) {
    case 'isolate':
      return {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.responseActions.endpoint.isolate",
          defaultMessage: "Isolate"
        }),
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.responseActions.endpoint.isolateDescription",
          defaultMessage: "Quarantine a host from the network to prevent further spread of threats and limit potential damage"
        }),
        tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.responseActions.endpoint.isolateTooltip",
          defaultMessage: "Insufficient privileges to isolate hosts. Contact your Kibana administrator if you think you should have this permission."
        })
      };
    default:
      return {
        title: '',
        description: '',
        tooltip: ''
      };
  }
};
const EndpointActionText = /*#__PURE__*/_react.default.memo(EndpointActionTextComponent);
exports.EndpointActionText = EndpointActionText;