"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBadgeText = exports.getBadgeColor = void 0;
var _lodash = require("lodash");
var _rule_monitoring = require("../../../../../../../common/detection_engine/rule_monitoring");
var _utility_types = require("../../../../../../../common/utility_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBadgeColor = logLevel => {
  switch (logLevel) {
    case _rule_monitoring.LogLevel.trace:
      return 'hollow';
    case _rule_monitoring.LogLevel.debug:
      return 'hollow';
    case _rule_monitoring.LogLevel.info:
      return 'default';
    case _rule_monitoring.LogLevel.warn:
      return 'warning';
    case _rule_monitoring.LogLevel.error:
      return 'danger';
    default:
      return (0, _utility_types.assertUnreachable)(logLevel, 'Unknown log level');
  }
};
exports.getBadgeColor = getBadgeColor;
const getBadgeText = logLevel => {
  return (0, _lodash.upperCase)(logLevel);
};
exports.getBadgeText = getBadgeText;