"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../common/constants");
var _types = require("../../../../app/types");
var _import_data_modal = require("../../../../common/components/import_data_modal");
var _links = require("../../../../common/components/links");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _use_bool_state = require("../../../../common/hooks/use_bool_state");
var _kibana = require("../../../../common/lib/kibana");
var _privileges = require("../../../../common/utils/privileges");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _missing_privileges_callout = require("../../../../detections/components/callouts/missing_privileges_callout");
var _ml_job_compatibility_callout = require("../../../../detections/components/callouts/ml_job_compatibility_callout");
var _need_admin_for_update_callout = require("../../../../detections/components/callouts/need_admin_for_update_callout");
var _add_elastic_rules_button = require("../../../../detections/components/rules/pre_packaged_rules/add_elastic_rules_button");
var _value_lists_management_flyout = require("../../../../detections/components/value_lists_management_flyout");
var _user_info = require("../../../../detections/components/user_info");
var _use_lists_config = require("../../../../detections/containers/detection_engine/lists/use_lists_config");
var _helpers = require("../../../../detections/pages/detection_engine/rules/helpers");
var i18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
var _use_fetch_rule_management_filters_query = require("../../../rule_management/api/hooks/use_fetch_rule_management_filters_query");
var _use_find_rules_query = require("../../../rule_management/api/hooks/use_find_rules_query");
var _logic = require("../../../rule_management/logic");
var _maintenance_window_callout = require("../../components/maintenance_window_callout/maintenance_window_callout");
var _rules_table = require("../../components/rules_table");
var _rules_table_context = require("../../components/rules_table/rules_table/rules_table_context");
var _super_header = require("./super_header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesPageComponent = () => {
  const [isImportModalVisible, showImportModal, hideImportModal] = (0, _use_bool_state.useBoolState)();
  const [isValueListFlyoutVisible, showValueListFlyout, hideValueListFlyout] = (0, _use_bool_state.useBoolState)();
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const invalidateFindRulesQuery = (0, _use_find_rules_query.useInvalidateFindRulesQuery)();
  const invalidateFetchRuleManagementFilters = (0, _use_fetch_rule_management_filters_query.useInvalidateFetchRuleManagementFiltersQuery)();
  const invalidateRules = (0, _react.useCallback)(() => {
    invalidateFindRulesQuery();
    invalidateFetchRuleManagementFilters();
  }, [invalidateFindRulesQuery, invalidateFetchRuleManagementFilters]);
  const [{
    loading: userInfoLoading,
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const {
    loading: listsConfigLoading,
    canWriteIndex: canWriteListsIndex,
    needsConfiguration: needsListsConfiguration
  } = (0, _use_lists_config.useListsConfig)();
  const loading = userInfoLoading || listsConfigLoading;
  if ((0, _helpers.redirectToDetections)(isSignalIndexExists, isAuthenticated, hasEncryptionKey, needsListsConfiguration)) {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.alerts,
      path: (0, _redirect_to_detection_engine.getDetectionEngineUrl)()
    });
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_need_admin_for_update_callout.NeedAdminForUpdateRulesCallOut, null), /*#__PURE__*/_react.default.createElement(_missing_privileges_callout.MissingPrivilegesCallOut, null), /*#__PURE__*/_react.default.createElement(_ml_job_compatibility_callout.MlJobCompatibilityCallout, null), /*#__PURE__*/_react.default.createElement(_value_lists_management_flyout.ValueListsFlyout, {
    showFlyout: isValueListFlyoutVisible,
    onClose: hideValueListFlyout
  }), /*#__PURE__*/_react.default.createElement(_import_data_modal.ImportDataModal, {
    checkBoxLabel: i18n.OVERWRITE_WITH_SAME_NAME,
    closeModal: hideImportModal,
    description: i18n.SELECT_RULE,
    errorMessage: i18n.IMPORT_FAILED,
    failedDetailed: i18n.IMPORT_FAILED_DETAILED,
    importComplete: invalidateRules,
    importData: _logic.importRules,
    successMessage: i18n.SUCCESSFULLY_IMPORTED_RULES,
    showModal: isImportModalVisible,
    submitBtnText: i18n.IMPORT_RULE_BTN_TITLE,
    subtitle: i18n.INITIAL_PROMPT_TEXT,
    title: i18n.IMPORT_RULE,
    showExceptionsCheckBox: true,
    showCheckBox: true,
    showActionConnectorsCheckBox: true
  }), /*#__PURE__*/_react.default.createElement(_rules_table_context.RulesTableContextProvider, null, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_super_header.SuperHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_elastic_rules_button.AddElasticRulesButton, {
    isDisabled: !canUserCRUD || loading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18n.UPLOAD_VALUE_LISTS_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "open-value-lists-modal-button",
    iconType: "importAction",
    isDisabled: !canWriteListsIndex || !canUserCRUD || loading,
    onClick: showValueListFlyout
  }, i18n.IMPORT_VALUE_LISTS))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "rules-import-modal-button",
    iconType: "importAction",
    isDisabled: !(0, _privileges.hasUserCRUDPermission)(canUserCRUD) || loading,
    onClick: showImportModal
  }, i18n.IMPORT_RULE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    "data-test-subj": "create-new-rule",
    fill: true,
    iconType: "plusInCircle",
    isDisabled: !(0, _privileges.hasUserCRUDPermission)(canUserCRUD) || loading,
    deepLinkId: _types.SecurityPageName.rulesCreate
  }, i18n.ADD_NEW_RULE)))), /*#__PURE__*/_react.default.createElement(_maintenance_window_callout.MaintenanceWindowCallout, null), /*#__PURE__*/_react.default.createElement(_rules_table.AllRules, {
    "data-test-subj": "all-rules"
  }))), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.rules
  }));
};
const RulesPage = /*#__PURE__*/_react.default.memo(RulesPageComponent);
exports.RulesPage = RulesPage;