"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRulesTableActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../common/detection_engine/rule_management/constants");
var _request_schema = require("../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _kibana = require("../../../../common/lib/kibana");
var _privileges = require("../../../../common/utils/privileges");
var i18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
var _use_bulk_export = require("../../../rule_management/logic/bulk_actions/use_bulk_export");
var _use_execute_bulk_action = require("../../../rule_management/logic/bulk_actions/use_execute_bulk_action");
var _use_download_exported_rules = require("../../../rule_management/logic/bulk_actions/use_download_exported_rules");
var _use_has_actions_privileges = require("./use_has_actions_privileges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRulesTableActions = ({
  showExceptionsDuplicateConfirmation
}) => {
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const hasActionsPrivileges = (0, _use_has_actions_privileges.useHasActionsPrivileges)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    executeBulkAction
  } = (0, _use_execute_bulk_action.useExecuteBulkAction)();
  const {
    bulkExport
  } = (0, _use_bulk_export.useBulkExport)();
  const downloadExportedRules = (0, _use_download_exported_rules.useDownloadExportedRules)();
  return [{
    type: 'icon',
    'data-test-subj': 'editRuleAction',
    description: i18n.EDIT_RULE_SETTINGS,
    name: !hasActionsPrivileges ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      content: i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.EDIT_RULE_SETTINGS)) : i18n.EDIT_RULE_SETTINGS,
    icon: 'controlsHorizontal',
    onClick: rule => (0, _use_execute_bulk_action.goToRuleEditPage)(rule.id, navigateToApp),
    enabled: rule => (0, _privileges.canEditRuleWithActions)(rule, hasActionsPrivileges)
  }, {
    type: 'icon',
    'data-test-subj': 'duplicateRuleAction',
    description: i18n.DUPLICATE_RULE,
    icon: 'copy',
    name: !hasActionsPrivileges ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      content: i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.DUPLICATE_RULE)) : i18n.DUPLICATE_RULE,
    enabled: rule => (0, _privileges.canEditRuleWithActions)(rule, hasActionsPrivileges),
    // TODO extract those handlers to hooks, like useDuplicateRule
    onClick: async rule => {
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.DUPLICATE
      });
      const modalDuplicationConfirmationResult = await showExceptionsDuplicateConfirmation();
      if (modalDuplicationConfirmationResult === null) {
        return;
      }
      const result = await executeBulkAction({
        type: _request_schema.BulkActionType.duplicate,
        ids: [rule.id],
        duplicatePayload: {
          include_exceptions: modalDuplicationConfirmationResult === _constants.DuplicateOptions.withExceptions || modalDuplicationConfirmationResult === _constants.DuplicateOptions.withExceptionsExcludeExpiredExceptions,
          include_expired_exceptions: !(modalDuplicationConfirmationResult === _constants.DuplicateOptions.withExceptionsExcludeExpiredExceptions)
        }
      });
      const createdRules = result === null || result === void 0 ? void 0 : result.attributes.results.created;
      if (createdRules !== null && createdRules !== void 0 && createdRules.length) {
        (0, _use_execute_bulk_action.goToRuleEditPage)(createdRules[0].id, navigateToApp);
      }
    }
  }, {
    type: 'icon',
    'data-test-subj': 'exportRuleAction',
    description: i18n.EXPORT_RULE,
    icon: 'exportAction',
    name: i18n.EXPORT_RULE,
    onClick: async rule => {
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.EXPORT
      });
      const response = await bulkExport({
        ids: [rule.id]
      });
      if (response) {
        await downloadExportedRules(response);
      }
    },
    enabled: rule => !rule.immutable
  }, {
    type: 'icon',
    'data-test-subj': 'deleteRuleAction',
    description: i18n.DELETE_RULE,
    icon: 'trash',
    name: i18n.DELETE_RULE,
    onClick: async rule => {
      startTransaction({
        name: _user_actions.SINGLE_RULE_ACTIONS.DELETE
      });
      await executeBulkAction({
        type: _request_schema.BulkActionType.delete,
        ids: [rule.id]
      });
    }
  }];
};
exports.useRulesTableActions = useRulesTableActions;