"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpgradePrebuiltRulesTableContext = exports.UpgradePrebuiltRulesTableContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_upgrade_security_packages = require("../../../../rule_management/logic/use_upgrade_security_packages");
var _use_installed_security_jobs = require("../../../../../common/components/ml/hooks/use_installed_security_jobs");
var _use_bool_state = require("../../../../../common/hooks/use_bool_state");
var _affected_job_ids = require("../../../../../detections/components/callouts/ml_job_compatibility_callout/affected_job_ids");
var _invariant = require("../../../../../../common/utils/invariant");
var _use_perform_rule_upgrade = require("../../../../rule_management/logic/prebuilt_rules/use_perform_rule_upgrade");
var _use_prebuilt_rules_upgrade_review = require("../../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_upgrade_review");
var _use_filter_prebuilt_rules_to_upgrade = require("./use_filter_prebuilt_rules_to_upgrade");
var _use_async_confirmation = require("../rules_table/use_async_confirmation");
var _ml_job_upgrade_modal = require("../../../../../detections/components/modals/ml_job_upgrade_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpgradePrebuiltRulesTableContext = /*#__PURE__*/(0, _react.createContext)(null);
const UpgradePrebuiltRulesTableContextProvider = ({
  children
}) => {
  const [loadingRules, setLoadingRules] = (0, _react.useState)([]);
  const [selectedRules, setSelectedRules] = (0, _react.useState)([]);
  const [filterOptions, setFilterOptions] = (0, _react.useState)({
    filter: '',
    tags: []
  });
  const isUpgradingSecurityPackages = (0, _use_upgrade_security_packages.useIsUpgradingSecurityPackages)();
  const {
    data: {
      rules,
      stats: {
        tags
      }
    } = {
      rules: [],
      stats: {
        tags: []
      }
    },
    refetch,
    dataUpdatedAt,
    isFetched,
    isLoading,
    isRefetching
  } = (0, _use_prebuilt_rules_upgrade_review.usePrebuiltRulesUpgradeReview)({
    refetchInterval: false,
    // Disable automatic refetching since request is expensive
    keepPreviousData: true // Use this option so that the state doesn't jump between "success" and "loading" on page change
  });

  const {
    mutateAsync: upgradeAllRulesRequest
  } = (0, _use_perform_rule_upgrade.usePerformUpgradeAllRules)();
  const {
    mutateAsync: upgradeSpecificRulesRequest
  } = (0, _use_perform_rule_upgrade.usePerformUpgradeSpecificRules)();

  // Wrapper to add confirmation modal for users who may be running older ML Jobs that would
  // be overridden by updating their rules. For details, see: https://github.com/elastic/kibana/issues/128121
  const [isUpgradeModalVisible, showUpgradeModal, hideUpgradeModal] = (0, _use_bool_state.useBoolState)(false);
  const {
    loading: loadingJobs,
    jobs
  } = (0, _use_installed_security_jobs.useInstalledSecurityJobs)();
  const legacyJobsInstalled = jobs.filter(job => _affected_job_ids.affectedJobIds.includes(job.id));
  const [confirmUpgrade, handleUpgradeConfirm, handleUpgradeCancel] = (0, _use_async_confirmation.useAsyncConfirmation)({
    onInit: showUpgradeModal,
    onFinish: hideUpgradeModal
  });
  const shouldConfirmUpgrade = legacyJobsInstalled.length > 0;
  const upgradeOneRule = (0, _react.useCallback)(async ruleId => {
    const rule = rules.find(r => r.rule_id === ruleId);
    (0, _invariant.invariant)(rule, `Rule with id ${ruleId} not found`);
    setLoadingRules(prev => [...prev, ruleId]);
    try {
      var _rule$diff$fields$ver, _rule$diff$fields$ver2;
      if (shouldConfirmUpgrade && !(await confirmUpgrade())) {
        return;
      }
      await upgradeSpecificRulesRequest([{
        rule_id: ruleId,
        version: (_rule$diff$fields$ver = (_rule$diff$fields$ver2 = rule.diff.fields.version) === null || _rule$diff$fields$ver2 === void 0 ? void 0 : _rule$diff$fields$ver2.target_version) !== null && _rule$diff$fields$ver !== void 0 ? _rule$diff$fields$ver : rule.rule.version,
        revision: rule.revision
      }]);
    } finally {
      setLoadingRules(prev => prev.filter(id => id !== ruleId));
    }
  }, [confirmUpgrade, rules, shouldConfirmUpgrade, upgradeSpecificRulesRequest]);
  const upgradeSelectedRules = (0, _react.useCallback)(async () => {
    const rulesToUpgrade = selectedRules.map(rule => {
      var _rule$diff$fields$ver3, _rule$diff$fields$ver4;
      return {
        rule_id: rule.rule_id,
        version: (_rule$diff$fields$ver3 = (_rule$diff$fields$ver4 = rule.diff.fields.version) === null || _rule$diff$fields$ver4 === void 0 ? void 0 : _rule$diff$fields$ver4.target_version) !== null && _rule$diff$fields$ver3 !== void 0 ? _rule$diff$fields$ver3 : rule.rule.version,
        revision: rule.revision
      };
    });
    setLoadingRules(prev => [...prev, ...rulesToUpgrade.map(r => r.rule_id)]);
    try {
      if (shouldConfirmUpgrade && !(await confirmUpgrade())) {
        return;
      }
      await upgradeSpecificRulesRequest(rulesToUpgrade);
    } finally {
      setLoadingRules(prev => prev.filter(id => !rulesToUpgrade.some(r => r.rule_id === id)));
      setSelectedRules([]);
    }
  }, [confirmUpgrade, selectedRules, shouldConfirmUpgrade, upgradeSpecificRulesRequest]);
  const upgradeAllRules = (0, _react.useCallback)(async () => {
    // Unselect all rules so that the table doesn't show the "bulk actions" bar
    setLoadingRules(prev => [...prev, ...rules.map(r => r.rule_id)]);
    try {
      if (shouldConfirmUpgrade && !(await confirmUpgrade())) {
        return;
      }
      await upgradeAllRulesRequest();
    } finally {
      setLoadingRules([]);
      setSelectedRules([]);
    }
  }, [confirmUpgrade, rules, shouldConfirmUpgrade, upgradeAllRulesRequest]);
  const actions = (0, _react.useMemo)(() => ({
    reFetchRules: refetch,
    upgradeOneRule,
    upgradeSelectedRules,
    upgradeAllRules,
    setFilterOptions,
    selectRules: setSelectedRules
  }), [refetch, upgradeOneRule, upgradeSelectedRules, upgradeAllRules]);
  const filteredRules = (0, _use_filter_prebuilt_rules_to_upgrade.useFilterPrebuiltRulesToUpgrade)({
    filterOptions,
    rules
  });
  const providerValue = (0, _react.useMemo)(() => {
    return {
      state: {
        rules,
        filteredRules,
        filterOptions,
        tags,
        isFetched,
        isLoading: isLoading && loadingJobs,
        isRefetching,
        isUpgradingSecurityPackages,
        selectedRules,
        loadingRules,
        lastUpdated: dataUpdatedAt
      },
      actions
    };
  }, [rules, filteredRules, filterOptions, tags, isFetched, isLoading, loadingJobs, isRefetching, isUpgradingSecurityPackages, selectedRules, loadingRules, dataUpdatedAt, actions]);
  return /*#__PURE__*/_react.default.createElement(UpgradePrebuiltRulesTableContext.Provider, {
    value: providerValue
  }, isUpgradeModalVisible && /*#__PURE__*/_react.default.createElement(_ml_job_upgrade_modal.MlJobUpgradeModal, {
    jobs: legacyJobsInstalled,
    onCancel: handleUpgradeCancel,
    onConfirm: handleUpgradeConfirm
  }), children);
};
exports.UpgradePrebuiltRulesTableContextProvider = UpgradePrebuiltRulesTableContextProvider;
const useUpgradePrebuiltRulesTableContext = () => {
  const rulesTableContext = (0, _react.useContext)(UpgradePrebuiltRulesTableContext);
  (0, _invariant.invariant)(rulesTableContext, 'useUpgradePrebuiltRulesTableContext should be used inside UpgradePrebuiltRulesTableContextProvider');
  return rulesTableContext;
};
exports.useUpgradePrebuiltRulesTableContext = useUpgradePrebuiltRulesTableContext;