"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradePrebuiltRulesTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("../../../../../detections/pages/detection_engine/rules/translations"));
var _constants = require("../constants");
var _rules_changelog_link = require("../rules_changelog_link");
var _upgrade_prebuilt_rules_table_buttons = require("./upgrade_prebuilt_rules_table_buttons");
var _upgrade_prebuilt_rules_table_context = require("./upgrade_prebuilt_rules_table_context");
var _upgrade_prebuilt_rules_table_filters = require("./upgrade_prebuilt_rules_table_filters");
var _use_upgrade_prebuilt_rules_table_columns = require("./use_upgrade_prebuilt_rules_table_columns");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_ITEMS_MESSAGE = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.NO_RULES_AVAILABLE_FOR_UPGRADE),
  titleSize: "s",
  body: i18n.NO_RULES_AVAILABLE_FOR_UPGRADE_BODY
});

/**
 * Table Component for displaying rules that have available updates
 */
const UpgradePrebuiltRulesTable = /*#__PURE__*/_react.default.memo(() => {
  const upgradeRulesTableContext = (0, _upgrade_prebuilt_rules_table_context.useUpgradePrebuiltRulesTableContext)();
  const {
    state: {
      rules,
      filteredRules,
      isFetched,
      isLoading,
      selectedRules,
      isRefetching,
      isUpgradingSecurityPackages
    },
    actions: {
      selectRules
    }
  } = upgradeRulesTableContext;
  const rulesColumns = (0, _use_upgrade_prebuilt_rules_table_columns.useUpgradePrebuiltRulesTableColumns)();
  const isTableEmpty = isFetched && rules.length === 0;
  const shouldShowProgress = isUpgradingSecurityPackages || isRefetching;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "loadingRulesInfoProgress",
    size: "xs",
    position: "absolute",
    color: "accent"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null)),
    loadedContent: isTableEmpty ? NO_ITEMS_MESSAGE : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_rules_changelog_link.RulesChangelogLink, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart",
      gutterSize: "s",
      responsive: false,
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_upgrade_prebuilt_rules_table_filters.UpgradePrebuiltRulesTableFilters, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_upgrade_prebuilt_rules_table_buttons.UpgradePrebuiltRulesTableButtons, null))))), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: filteredRules,
      sorting: true,
      pagination: {
        initialPageSize: _constants.RULES_TABLE_INITIAL_PAGE_SIZE,
        pageSizeOptions: _constants.RULES_TABLE_PAGE_SIZE_OPTIONS
      },
      isSelectable: true,
      selection: {
        selectable: () => true,
        onSelectionChange: selectRules,
        initialSelected: selectedRules
      },
      itemId: "rule_id",
      "data-test-subj": "rules-upgrades-table",
      columns: rulesColumns
    }))
  }));
});
exports.UpgradePrebuiltRulesTable = UpgradePrebuiltRulesTable;
UpgradePrebuiltRulesTable.displayName = 'UpgradePrebuiltRulesTable';