"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTables = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _loader = require("../../../../common/components/loader");
var _use_bool_state = require("../../../../common/hooks/use_bool_state");
var _use_value_changed = require("../../../../common/hooks/use_value_changed");
var _load_empty_prompt = require("../../../../detections/components/rules/pre_packaged_rules/load_empty_prompt");
var i18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
var _bulk_action_dry_run_confirmation = require("./bulk_actions/bulk_action_dry_run_confirmation");
var _bulk_edit_flyout = require("./bulk_actions/bulk_edit_flyout");
var _use_bulk_actions = require("./bulk_actions/use_bulk_actions");
var _use_bulk_actions_confirmation = require("./bulk_actions/use_bulk_actions_confirmation");
var _use_bulk_actions_dry_run = require("./bulk_actions/use_bulk_actions_dry_run");
var _use_bulk_edit_form_flyout = require("./bulk_actions/use_bulk_edit_form_flyout");
var _rules_table_context = require("./rules_table/rules_table_context");
var _use_async_confirmation = require("./rules_table/use_async_confirmation");
var _rules_table_filters = require("./rules_table_filters/rules_table_filters");
var _rules_table_toolbar = require("./rules_table_toolbar");
var _rules_table_utility_bar = require("../rules_table_utility_bar/rules_table_utility_bar");
var _use_columns = require("./use_columns");
var _user_info = require("../../../../detections/components/user_info");
var _privileges = require("../../../../common/utils/privileges");
var _use_bulk_duplicate_confirmation = require("./bulk_actions/use_bulk_duplicate_confirmation");
var _bulk_duplicate_exceptions_confirmation = require("./bulk_actions/bulk_duplicate_exceptions_confirmation");
var _use_start_ml_jobs = require("../../../rule_management/logic/use_start_ml_jobs");
var _constants = require("./constants");
var _use_rule_management_filters = require("../../../rule_management/logic/use_rule_management_filters");
var _use_upgrade_security_packages = require("../../../rule_management/logic/use_upgrade_security_packages");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_SORT_FIELD = 'enabled';
const NO_ITEMS_MESSAGE = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.NO_RULES),
  titleSize: "xs",
  body: i18n.NO_RULES_BODY
});

/**
 * Table Component for displaying all Rules for a given cluster. Provides the ability to filter
 * by name, sort by enabled, and perform the following actions:
 *   * Enable/Disable
 *   * Duplicate
 *   * Delete
 *   * Import/Export
 */
// eslint-disable-next-line complexity
const RulesTables = /*#__PURE__*/_react.default.memo(({
  selectedTab
}) => {
  var _selectedRuleIds$leng, _bulkActionsDryRunRes;
  const [{
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const hasPermissions = (0, _privileges.hasUserCRUDPermission)(canUserCRUD);
  const isUpgradingSecurityPackages = (0, _use_upgrade_security_packages.useIsUpgradingSecurityPackages)();
  const tableRef = (0, _react.useRef)(null);
  const rulesTableContext = (0, _rules_table_context.useRulesTableContext)();
  const {
    data: ruleManagementFilters
  } = (0, _use_rule_management_filters.useRuleManagementFilters)();
  const {
    state: {
      rules,
      filterOptions,
      isPreflightInProgress,
      isAllSelected,
      isFetched,
      isLoading,
      isRefetching,
      loadingRuleIds,
      loadingRulesAction,
      pagination,
      selectedRuleIds,
      sortingOptions
    },
    actions: {
      setIsAllSelected,
      setPage,
      setPerPage,
      setSelectedRuleIds,
      setSortingOptions
    }
  } = rulesTableContext;
  const [isDeleteConfirmationVisible, showDeleteConfirmation, hideDeleteConfirmation] = (0, _use_bool_state.useBoolState)();
  const [confirmDeletion, handleDeletionConfirm, handleDeletionCancel] = (0, _use_async_confirmation.useAsyncConfirmation)({
    onInit: showDeleteConfirmation,
    onFinish: hideDeleteConfirmation
  });
  const {
    bulkActionsDryRunResult,
    bulkAction,
    isBulkActionConfirmationVisible,
    showBulkActionConfirmation,
    cancelBulkActionConfirmation,
    approveBulkActionConfirmation
  } = (0, _use_bulk_actions_confirmation.useBulkActionsConfirmation)();
  const {
    isBulkDuplicateConfirmationVisible,
    showBulkDuplicateConfirmation,
    cancelRuleDuplication,
    confirmRuleDuplication
  } = (0, _use_bulk_duplicate_confirmation.useBulkDuplicateExceptionsConfirmation)();
  const {
    bulkEditActionType,
    isBulkEditFlyoutVisible,
    handleBulkEditFormConfirm,
    handleBulkEditFormCancel,
    completeBulkEditForm
  } = (0, _use_bulk_edit_form_flyout.useBulkEditFormFlyout)();
  const {
    isBulkActionsDryRunLoading,
    executeBulkActionsDryRun
  } = (0, _use_bulk_actions_dry_run.useBulkActionsDryRun)();
  const getBulkItemsPopoverContent = (0, _use_bulk_actions.useBulkActions)({
    filterOptions,
    confirmDeletion,
    showBulkActionConfirmation,
    showBulkDuplicateConfirmation,
    completeBulkEditForm,
    executeBulkActionsDryRun
  });
  const paginationMemo = (0, _react.useMemo)(() => {
    return {
      pageIndex: pagination.page - 1,
      pageSize: pagination.perPage,
      totalItemCount: pagination.total,
      pageSizeOptions: _constants.RULES_TABLE_PAGE_SIZE_OPTIONS
    };
  }, [pagination.page, pagination.perPage, pagination.total]);
  const tableOnChangeCallback = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    var _ref, _sort$direction;
    setSortingOptions({
      field: (_ref = sort === null || sort === void 0 ? void 0 : sort.field) !== null && _ref !== void 0 ? _ref : INITIAL_SORT_FIELD,
      // Narrowing EuiBasicTable sorting types
      order: (_sort$direction = sort === null || sort === void 0 ? void 0 : sort.direction) !== null && _sort$direction !== void 0 ? _sort$direction : 'desc'
    });
    setPage(page.index + 1);
    setPerPage(page.size);
  }, [setPage, setPerPage, setSortingOptions]);
  const {
    loading: isLoadingJobs,
    jobs: mlJobs,
    startMlJobs
  } = (0, _use_start_ml_jobs.useStartMlJobs)();
  const rulesColumns = (0, _use_columns.useRulesColumns)({
    hasCRUDPermissions: hasPermissions,
    isLoadingJobs,
    mlJobs,
    startMlJobs,
    showExceptionsDuplicateConfirmation: showBulkDuplicateConfirmation
  });
  const monitoringColumns = (0, _use_columns.useMonitoringColumns)({
    hasCRUDPermissions: hasPermissions,
    isLoadingJobs,
    mlJobs,
    startMlJobs,
    showExceptionsDuplicateConfirmation: showBulkDuplicateConfirmation
  });
  const isSelectAllCalled = (0, _react.useRef)(false);

  // TODO Remove this synchronization logic after https://github.com/elastic/eui/issues/6184 is implemented
  // Synchronize selectedRuleIds with EuiBasicTable's selected rows
  (0, _use_value_changed.useValueChanged)(ruleIds => {
    if (tableRef.current != null) {
      tableRef.current.setSelection(rules.filter(rule => ruleIds.includes(rule.id)));
    }
  }, selectedRuleIds);
  const isTableSelectable = hasPermissions && (selectedTab === _rules_table_toolbar.AllRulesTabs.management || selectedTab === _rules_table_toolbar.AllRulesTabs.monitoring);
  const euiBasicTableSelectionProps = (0, _react.useMemo)(() => ({
    selectable: item => !loadingRuleIds.includes(item.id),
    onSelectionChange: selected => {
      /**
       * EuiBasicTable doesn't provide declarative API to control selected rows.
       * This limitation requires us to synchronize selection state manually using setSelection().
       * But it creates a chain reaction when the user clicks Select All:
       * selectAll() -> setSelection() -> onSelectionChange() -> setSelection().
       * To break the chain we should check whether the onSelectionChange was triggered
       * by the Select All action or not.
       *
       */
      if (isSelectAllCalled.current) {
        isSelectAllCalled.current = false;
        // Handle special case of unselecting all rules via checkbox
        // after all rules were selected via Bulk select.
        if (selected.length === 0) {
          setIsAllSelected(false);
          setSelectedRuleIds([]);
        }
      } else {
        setSelectedRuleIds(selected.map(({
          id
        }) => id));
        setIsAllSelected(false);
      }
    }
  }), [loadingRuleIds, setIsAllSelected, setSelectedRuleIds]);
  const toggleSelectAll = (0, _react.useCallback)(() => {
    isSelectAllCalled.current = true;
    setIsAllSelected(!isAllSelected);
    setSelectedRuleIds(!isAllSelected ? rules.map(({
      id
    }) => id) : []);
  }, [rules, isAllSelected, setIsAllSelected, setSelectedRuleIds]);
  const isTableEmpty = (ruleManagementFilters === null || ruleManagementFilters === void 0 ? void 0 : ruleManagementFilters.rules_summary.custom_count) === 0 && (ruleManagementFilters === null || ruleManagementFilters === void 0 ? void 0 : ruleManagementFilters.rules_summary.prebuilt_installed_count) === 0;
  const shouldShowRulesTable = !isLoading && !isTableEmpty;
  let tableProps;
  switch (selectedTab) {
    case _rules_table_toolbar.AllRulesTabs.management:
      tableProps = {
        'data-test-subj': 'rules-management-table',
        columns: rulesColumns
      };
      break;
    case _rules_table_toolbar.AllRulesTabs.monitoring:
      tableProps = {
        'data-test-subj': 'rules-monitoring-table',
        columns: monitoringColumns
      };
      break;
    default:
      tableProps = {
        'data-test-subj': 'rules-management-table',
        columns: rulesColumns
      };
      break;
  }
  const shouldShowLinearProgress = isFetched && isRefetching || isUpgradingSecurityPackages;
  const shouldShowLoadingOverlay = !isFetched && isRefetching || isPreflightInProgress;
  const numberOfSelectedRules = isAllSelected ? pagination.total : (_selectedRuleIds$leng = selectedRuleIds === null || selectedRuleIds === void 0 ? void 0 : selectedRuleIds.length) !== null && _selectedRuleIds$leng !== void 0 ? _selectedRuleIds$leng : 1;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowLinearProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "loadingRulesInfoProgress",
    size: "xs",
    position: "absolute",
    color: "accent"
  }), shouldShowLoadingOverlay && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    "data-test-subj": "loadingPanelAllRulesTable",
    overlay: true,
    size: "xl"
  }), isTableEmpty && /*#__PURE__*/_react.default.createElement(_load_empty_prompt.PrePackagedRulesPrompt, null), isDeleteConfirmationVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: i18n.DELETE_CONFIRMATION_TITLE,
    onCancel: handleDeletionCancel,
    onConfirm: handleDeletionConfirm,
    confirmButtonText: i18n.DELETE_CONFIRMATION_CONFIRM,
    cancelButtonText: i18n.DELETE_CONFIRMATION_CANCEL,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    "data-test-subj": "allRulesDeleteConfirmationModal"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.DELETE_CONFIRMATION_BODY)), isBulkActionConfirmationVisible && bulkAction && /*#__PURE__*/_react.default.createElement(_bulk_action_dry_run_confirmation.BulkActionDryRunConfirmation, {
    bulkAction: bulkAction,
    result: bulkActionsDryRunResult,
    onCancel: cancelBulkActionConfirmation,
    onConfirm: approveBulkActionConfirmation
  }), isBulkDuplicateConfirmationVisible && /*#__PURE__*/_react.default.createElement(_bulk_duplicate_exceptions_confirmation.BulkActionDuplicateExceptionsConfirmation, {
    onCancel: cancelRuleDuplication,
    onConfirm: confirmRuleDuplication,
    rulesCount: numberOfSelectedRules
  }), isBulkEditFlyoutVisible && bulkEditActionType !== undefined && /*#__PURE__*/_react.default.createElement(_bulk_edit_flyout.BulkEditFlyout, {
    rulesCount: (_bulkActionsDryRunRes = bulkActionsDryRunResult === null || bulkActionsDryRunResult === void 0 ? void 0 : bulkActionsDryRunResult.succeededRulesCount) !== null && _bulkActionsDryRunRes !== void 0 ? _bulkActionsDryRunRes : 0,
    editAction: bulkEditActionType,
    onClose: handleBulkEditFormCancel,
    onConfirm: handleBulkEditFormConfirm
  }), shouldShowRulesTable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_rules_table_filters.RulesTableFilters, null), /*#__PURE__*/_react.default.createElement(_rules_table_utility_bar.RulesTableUtilityBar, {
    canBulkEdit: hasPermissions,
    onGetBulkItemsPopoverContent: getBulkItemsPopoverContent,
    onToggleSelectAll: toggleSelectAll,
    isBulkActionInProgress: isBulkActionsDryRunLoading || loadingRulesAction != null
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, (0, _extends2.default)({
    itemId: "id",
    items: rules,
    isSelectable: isTableSelectable,
    noItemsMessage: NO_ITEMS_MESSAGE,
    onChange: tableOnChangeCallback,
    pagination: paginationMemo,
    ref: tableRef,
    selection: isTableSelectable ? euiBasicTableSelectionProps : undefined,
    sorting: {
      sort: {
        // EuiBasicTable has incorrect `sort.field` types which accept only `keyof Item` and reject fields in dot notation
        field: sortingOptions.field,
        direction: sortingOptions.order
      }
    }
  }, tableProps))));
});
exports.RulesTables = RulesTables;
RulesTables.displayName = 'RulesTables';