"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOUR_TITLE = exports.SEARCH_CAPABILITIES_TITLE = exports.SEARCH_CAPABILITIES_DESCRIPTION = exports.PREVIOUS_STEP_LABEL = exports.NEXT_STEP_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOUR_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.featureTour.tourTitle', {
  defaultMessage: "What's new"
});
exports.TOUR_TITLE = TOUR_TITLE;
const PREVIOUS_STEP_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.featureTour.previousStepLabel', {
  defaultMessage: 'Go to previous step'
});
exports.PREVIOUS_STEP_LABEL = PREVIOUS_STEP_LABEL;
const NEXT_STEP_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.featureTour.nextStepLabel', {
  defaultMessage: 'Go to next step'
});
exports.NEXT_STEP_LABEL = NEXT_STEP_LABEL;
const SEARCH_CAPABILITIES_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.featureTour.searchCapabilitiesTitle', {
  defaultMessage: 'Enhanced search capabilities'
});
exports.SEARCH_CAPABILITIES_TITLE = SEARCH_CAPABILITIES_TITLE;
const SEARCH_CAPABILITIES_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.featureTour.searchCapabilitiesDescription', {
  defaultMessage: 'It is now possible to search rules by index patterns, like "filebeat-*", or by MITRE ATT&CK™ tactics or techniques, like "Defense Evasion" or "TA0005".'
});
exports.SEARCH_CAPABILITIES_DESCRIPTION = SEARCH_CAPABILITIES_DESCRIPTION;