"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.computeDryRunEditPayload = computeDryRunEditPayload;
var _request_schema = require("../../../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var _utility_types = require("../../../../../../../common/utility_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * helper utility that creates payload for _bulk_action API in dry mode
 * @param {BulkAction} action
 * @param {BulkActionEditType | undefined} editAction
 * @returns {BulkActionEditPayload[] | undefined}
 */
function computeDryRunEditPayload(editAction) {
  switch (editAction) {
    case _request_schema.BulkActionEditType.add_index_patterns:
    case _request_schema.BulkActionEditType.delete_index_patterns:
    case _request_schema.BulkActionEditType.set_index_patterns:
      return [{
        type: editAction,
        value: []
      }];
    case _request_schema.BulkActionEditType.add_tags:
    case _request_schema.BulkActionEditType.delete_tags:
    case _request_schema.BulkActionEditType.set_tags:
      return [{
        type: editAction,
        value: []
      }];
    case _request_schema.BulkActionEditType.set_timeline:
      return [{
        type: editAction,
        value: {
          timeline_id: '',
          timeline_title: ''
        }
      }];
    case _request_schema.BulkActionEditType.add_rule_actions:
    case _request_schema.BulkActionEditType.set_rule_actions:
      return [{
        type: editAction,
        value: {
          actions: []
        }
      }];
    case _request_schema.BulkActionEditType.set_schedule:
      return [{
        type: editAction,
        value: {
          interval: '5m',
          lookback: '1m'
        }
      }];
    default:
      (0, _utility_types.assertUnreachable)(editAction);
  }
  return [{
    type: editAction,
    value: []
  }];
}