"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_PLACEHOLDER = exports.INSTALL_SELECTED_RULES = exports.INSTALL_ALL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTALL_ALL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.addRules.installAllButtonTitle', {
  defaultMessage: 'Install all'
});
exports.INSTALL_ALL = INSTALL_ALL;
const INSTALL_SELECTED_RULES = numberOfSelectedRules => {
  return _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.addRules.installSelectedRules', {
    defaultMessage: 'Install {numberOfSelectedRules} selected rule(s)',
    values: {
      numberOfSelectedRules
    }
  });
};
exports.INSTALL_SELECTED_RULES = INSTALL_SELECTED_RULES;
const SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.addRules.searchBarPlaceholder', {
  defaultMessage: 'Search by rule name'
});
exports.SEARCH_PLACEHOLDER = SEARCH_PLACEHOLDER;