"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleIndices = void 0;
var _react = require("react");
var _use_security_jobs = require("../../../common/components/ml_popover/hooks/use_security_jobs");
var _use_get_jobs = require("../../../common/components/ml/hooks/use_get_jobs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRuleIndices = (machineLearningJobId, defaultRuleIndices) => {
  const memoMlJobIds = (0, _react.useMemo)(() => machineLearningJobId !== null && machineLearningJobId !== void 0 ? machineLearningJobId : [], [machineLearningJobId]);
  const {
    loading: mlSecurityJobLoading,
    jobs
  } = (0, _use_security_jobs.useSecurityJobs)();
  const memoSelectedMlJobs = (0, _react.useMemo)(() => jobs.filter(({
    id
  }) => memoMlJobIds.includes(id)), [jobs, memoMlJobIds]);

  // Filter jobs that are installed. For those jobs we can get the index pattern from `job.results_index_name` field
  const memoInstalledMlJobs = (0, _react.useMemo)(() => memoSelectedMlJobs.filter(({
    isInstalled
  }) => isInstalled).map(j => j.id), [memoSelectedMlJobs]);
  const {
    loading: mlInstalledJobLoading,
    jobs: installedJobs
  } = (0, _use_get_jobs.useGetInstalledJob)(memoInstalledMlJobs);
  const memoMlIndices = (0, _react.useMemo)(() => {
    const installedJobsIndices = installedJobs.map(j => `.ml-anomalies-${j.results_index_name}`);
    return [...new Set(installedJobsIndices)];
  }, [installedJobs]);
  const memoRuleIndices = (0, _react.useMemo)(() => {
    if (memoMlIndices.length > 0) {
      return memoMlIndices;
    } else {
      return defaultRuleIndices !== null && defaultRuleIndices !== void 0 ? defaultRuleIndices : [];
    }
  }, [defaultRuleIndices, memoMlIndices]);
  return {
    mlJobLoading: mlSecurityJobLoading || mlInstalledJobLoading,
    ruleIndices: memoRuleIndices
  };
};
exports.useRuleIndices = useRuleIndices;