"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrebuiltRulesUpgradeReview = void 0;
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_fetch_prebuilt_rules_upgrade_review_query = require("../../api/hooks/prebuilt_rules/use_fetch_prebuilt_rules_upgrade_review_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A wrapper around useQuery provides default values to the underlying query,
 * like query key, abortion signal, and error handler.
 *
 * @returns useQuery result
 */
const usePrebuiltRulesUpgradeReview = options => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _use_fetch_prebuilt_rules_upgrade_review_query.useFetchPrebuiltRulesUpgradeReviewQuery)({
    onError: error => addError(error, {
      title: i18n.RULE_AND_TIMELINE_FETCH_FAILURE
    }),
    ...options
  });
};
exports.usePrebuiltRulesUpgradeReview = usePrebuiltRulesUpgradeReview;