"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePerformAllRulesUpgradeMutation = exports.PERFORM_ALL_RULES_UPGRADE_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
var _urls = require("../../../../../../common/detection_engine/prebuilt_rules/api/urls");
var _use_find_rules_query = require("../use_find_rules_query");
var _use_fetch_rule_management_filters_query = require("../use_fetch_rule_management_filters_query");
var _use_fetch_rules_snooze_settings = require("../use_fetch_rules_snooze_settings");
var _use_fetch_prebuilt_rules_upgrade_review_query = require("./use_fetch_prebuilt_rules_upgrade_review_query");
var _use_fetch_prebuilt_rules_status_query = require("./use_fetch_prebuilt_rules_status_query");
var _api = require("../../api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PERFORM_ALL_RULES_UPGRADE_KEY = ['POST', 'ALL_RULES', _urls.PERFORM_RULE_UPGRADE_URL];
exports.PERFORM_ALL_RULES_UPGRADE_KEY = PERFORM_ALL_RULES_UPGRADE_KEY;
const usePerformAllRulesUpgradeMutation = options => {
  const invalidateFindRulesQuery = (0, _use_find_rules_query.useInvalidateFindRulesQuery)();
  const invalidateFetchRulesSnoozeSettings = (0, _use_fetch_rules_snooze_settings.useInvalidateFetchRulesSnoozeSettingsQuery)();
  const invalidateFetchRuleManagementFilters = (0, _use_fetch_rule_management_filters_query.useInvalidateFetchRuleManagementFiltersQuery)();
  const invalidateFetchPrebuiltRulesUpgradeReview = (0, _use_fetch_prebuilt_rules_upgrade_review_query.useInvalidateFetchPrebuiltRulesUpgradeReviewQuery)();
  const invalidateRuleStatus = (0, _use_fetch_prebuilt_rules_status_query.useInvalidateFetchPrebuiltRulesStatusQuery)();
  return (0, _reactQuery.useMutation)(() => (0, _api.performUpgradeAllRules)(), {
    ...options,
    mutationKey: PERFORM_ALL_RULES_UPGRADE_KEY,
    onSettled: (...args) => {
      invalidateFindRulesQuery();
      invalidateFetchRulesSnoozeSettings();
      invalidateFetchRuleManagementFilters();
      invalidateFetchPrebuiltRulesUpgradeReview();
      invalidateRuleStatus();
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    }
  });
};
exports.usePerformAllRulesUpgradeMutation = usePerformAllRulesUpgradeMutation;