"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddRuleDefaultException = void 0;
var _react = require("react");
var _api = require("../../rule_management/api/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for adding exceptions to a rule default exception list
 *
 */
const useAddRuleDefaultException = () => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const addRuleExceptionFunc = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    const abortCtrl = new AbortController();
    const addExceptionItemsToRule = async (exceptions, rules) => {
      setIsLoading(true);

      // TODO: Update once bulk route is added
      const result = await Promise.all(rules.map(async rule => (0, _api.addRuleExceptions)({
        items: exceptions,
        ruleId: rule.id,
        signal: abortCtrl.signal
      })));
      setIsLoading(false);
      return result.flatMap(r => r);
    };
    addRuleExceptionFunc.current = addExceptionItemsToRule;
    return () => {
      setIsLoading(false);
      abortCtrl.abort();
    };
  }, []);
  return [isLoading, addRuleExceptionFunc.current];
};
exports.useAddRuleDefaultException = useAddRuleDefaultException;