"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSharedListsTableColumns = exports.getRulesTableColumn = exports.enrichNewExceptionItems = exports.enrichItemsForSharedLists = exports.enrichItemsForDefaultRuleList = exports.enrichItemWithName = exports.enrichItemWithExpireTime = exports.enrichItemWithComment = exports.enrichExceptionItemsForUpdate = exports.enrichEndpointItems = void 0;
var _react = _interopRequireDefault(require("react"));
var _fp = require("lodash/fp");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _eui = require("@elastic/eui");
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _popover_items = require("../../../../common/components/popover_items");
var _constants = require("../../../../../common/constants");
var _components = require("../../../../exceptions/components");
var _helpers = require("../../utils/helpers");
var _links = require("../../../../common/components/links");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _rule_details = require("../../../rule_details_ui/pages/rule_details");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Adds user defined name to all new exceptionItems
 * @param commentToAdd new comment to add to item
 */
const enrichItemWithComment = commentToAdd => items => {
  return commentToAdd.trim() !== '' ? (0, _helpers.enrichNewExceptionItemsWithComments)(items, [{
    comment: commentToAdd
  }]) : items;
};

/**
 * Adds user defined name to all new exceptionItems
 * @param itemName exception item name
 */
exports.enrichItemWithComment = enrichItemWithComment;
const enrichItemWithName = itemName => items => {
  return itemName.trim() !== '' ? (0, _helpers.enrichNewExceptionItemsWithName)(items, itemName) : items;
};

/**
 * Adds expiration datetime to all new exceptionItems
 * @param expireTimeToAdd new expireTime to add to item
 */
exports.enrichItemWithName = enrichItemWithName;
const enrichItemWithExpireTime = expireTimeToAdd => items => (0, _helpers.enrichNewExceptionItemsWithExpireTime)(items, expireTimeToAdd);

/**
 * Modifies item entries to be in correct format and adds os selection to items
 * @param listType exception list type
 * @param selectedOs os selection
 */
exports.enrichItemWithExpireTime = enrichItemWithExpireTime;
const enrichEndpointItems = (listType, selectedOs) => items => {
  if (listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT) {
    return (0, _helpers.lowercaseHashValues)((0, _helpers.enrichExceptionItemsWithOS)(items, selectedOs));
  } else {
    return items;
  }
};

/**
 * Modifies exception items to prepare for creating as rule_default
 * list items
 * @param listType exception list type
 * @param addToRules boolean determining if user selected to add items to default rule list
 */
exports.enrichEndpointItems = enrichEndpointItems;
const enrichItemsForDefaultRuleList = (listType, addToRules) => items => {
  if (addToRules && listType !== _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT) {
    return (0, _helpers.enrichRuleExceptions)(items);
  } else {
    return items;
  }
};

/**
 * Prepares items to be added to shared exception lists
 * @param listType exception list type
 * @param addToSharedLists boolean determining if user selected to add items to shared list
 * @param lists shared exception lists that were selected to add items to
 */
exports.enrichItemsForDefaultRuleList = enrichItemsForDefaultRuleList;
const enrichItemsForSharedLists = (listType, addToSharedLists, lists) => items => {
  if (addToSharedLists && listType !== _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT) {
    return (0, _helpers.enrichSharedExceptions)(items, lists);
  } else {
    return items;
  }
};

/**
 * Series of utils to modify and prepare exception items for update or creation
 * @param itemName user defined exception item name
 * @param commentToAdd comment to be added to item
 * @param addToRules boolean determining if user selected to add items to default rule list
 * @param addToSharedLists boolean determining if user selected to add items to shared list
 * @param sharedLists shared exception lists that were selected to add items to
 * @param selectedOs os selection
 * @param listType exception list type
 * @param expireTime exception item expire time
 * @param items exception items to be modified
 */
exports.enrichItemsForSharedLists = enrichItemsForSharedLists;
const enrichNewExceptionItems = ({
  itemName,
  commentToAdd,
  addToRules,
  addToSharedLists,
  sharedLists,
  selectedOs,
  listType,
  expireTime,
  items
}) => {
  const enriched = (0, _fp.pipe)(enrichItemWithComment(commentToAdd), enrichItemWithExpireTime(expireTime), enrichItemWithName(itemName), enrichEndpointItems(listType, selectedOs), enrichItemsForDefaultRuleList(listType, addToRules), enrichItemsForSharedLists(listType, addToSharedLists, sharedLists))(items);
  return enriched;
};

/**
 * Series of utils to modify and prepare exception items for update or creation
 * @param itemName user defined exception item name
 * @param commentToAdd comment to be added to item
 * @param addToRules boolean determining if user selected to add items to default rule list
 * @param addToSharedLists boolean determining if user selected to add items to shared list
 * @param sharedLists shared exception lists that were selected to add items to
 * @param selectedOs os selection
 * @param listType exception list type
 * @param expireTime exception item expire time
 * @param items exception items to be modified
 */
exports.enrichNewExceptionItems = enrichNewExceptionItems;
const enrichExceptionItemsForUpdate = ({
  itemName,
  commentToAdd,
  selectedOs,
  listType,
  expireTime,
  items
}) => {
  const enriched = (0, _fp.pipe)(enrichItemWithComment(commentToAdd), enrichItemWithExpireTime(expireTime), enrichItemWithName(itemName), enrichEndpointItems(listType, selectedOs))(items);
  return enriched;
};

/**
 * Shared lists columns for EuiInMemoryTable
 */
exports.enrichExceptionItemsForUpdate = enrichExceptionItemsForUpdate;
const getSharedListsTableColumns = () => [{
  field: 'name',
  name: i18n.NAME_COLUMN,
  sortable: true,
  'data-test-subj': 'exceptionListNameCell'
}, {
  field: 'referenced_rules',
  name: 'Number of rules linked to',
  sortable: false,
  'data-test-subj': 'exceptionListRulesLinkedToIdCell',
  render: references => /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.HeaderMenu, {
    emptyButton: true,
    useCustomActions: true,
    actions: (0, _securitysolutionExceptionListComponents.generateLinkedRulesMenuItems)({
      dataTestSubj: 'addToSharedListsLinkedRulesMenu',
      linkedRules: references,
      securityLinkAnchorComponent: _components.ListDetailsLinkAnchor
    }),
    panelPaddingSize: "none",
    disableActions: false,
    text: references.length.toString(),
    dataTestSubj: "addToSharedListsLinkedRulesMenuAction"
  })
}, {
  name: i18n.ACTION_COLUMN,
  'data-test-subj': 'exceptionListRulesActionCell',
  render: list => {
    return /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
      "data-test-subj": "exceptionListActionCell-link",
      deepLinkId: _constants.SecurityPageName.exceptions,
      path: `/details/${list.list_id}`,
      external: true
    }, i18n.VIEW_LIST_DETAIL_ACTION);
  }
}];

/**
 * Rules columns for EuiInMemoryTable
 */
exports.getSharedListsTableColumns = getSharedListsTableColumns;
const getRulesTableColumn = () => [{
  field: 'name',
  align: 'left',
  name: i18n.NAME_COLUMN,
  sortable: true,
  'data-test-subj': 'ruleNameCell',
  truncateText: false
}, {
  field: 'tags',
  align: 'left',
  name: i18n.TAGS_COLUMN,
  'data-test-subj': 'ruleNameCell',
  render: tags => {
    if (tags.length === 0) {
      return null;
    }
    const renderItem = (tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: `${tag}-${i}`,
      "data-test-subj": "tag"
    }, tag);
    return /*#__PURE__*/_react.default.createElement(_popover_items.PopoverItems, {
      items: tags,
      popoverTitle: i18n.TAGS_COLUMN,
      popoverButtonTitle: tags.length.toString(),
      popoverButtonIcon: "tag",
      dataTestPrefix: "tags",
      renderItem: renderItem
    });
  }
}, {
  name: i18n.ACTION_COLUMN,
  'data-test-subj': 'ruleAction-view',
  render: rule => {
    return /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
      "data-test-subj": "ruleAction-viewDetails",
      deepLinkId: _constants.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRuleDetailsTabUrl)(rule.id, _rule_details.RuleDetailTabs.alerts),
      external: true
    }, i18n.VIEW_RULE_DETAIL_ACTION);
  }
}];
exports.getRulesTableColumn = getRulesTableColumn;