"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsExpireTime = void 0;
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SectionHeader = (0, _styledComponents.default)(_eui.EuiTitle)`
  ${() => (0, _styledComponents.css)`
    font-weight: ${({
  theme
}) => theme.eui.euiFontWeightSemiBold};
  `}
`;
const ExceptionItemExpireTime = ({
  expireTime,
  setExpireTime,
  setExpireError
}) => {
  const [dateTime, setDateTime] = (0, _react.useState)(expireTime);
  const [isInvalid, setIsInvalid] = (0, _react.useState)(false);
  const [errors, setErrors] = (0, _react.useState)([]);
  const handleChange = (0, _react.useCallback)(date => {
    setDateTime(date !== null && date !== void 0 ? date : undefined);
    setExpireTime(date !== null && date !== void 0 ? date : undefined);
    if (date !== null && date !== void 0 && date.isBefore()) {
      setIsInvalid(true);
      setErrors([i18n.EXCEPTION_EXPIRE_TIME_ERROR]);
      setExpireError(true);
    } else {
      setIsInvalid(false);
      setErrors([]);
      setExpireError(false);
    }
  }, [setDateTime, setExpireTime, setExpireError]);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(SectionHeader, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.EXCEPTION_EXPIRE_TIME_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: errors,
    isInvalid: isInvalid,
    label: i18n.EXPIRE_TIME_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    showTimeSelect: true,
    selected: dateTime,
    isInvalid: isInvalid,
    onChange: handleChange,
    onClear: () => handleChange(null),
    minDate: (0, _moment.default)()
  })));
};
const ExceptionsExpireTime = /*#__PURE__*/_react.default.memo(ExceptionItemExpireTime);
exports.ExceptionsExpireTime = ExceptionsExpireTime;
ExceptionsExpireTime.displayName = 'ExceptionsExpireTime';