"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkRuleSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkRuleSwitch = /*#__PURE__*/(0, _react.memo)(({
  rule,
  linkedRules,
  onRuleLinkChange
}) => {
  const isRuleLinked = (0, _react.useMemo)(() => Boolean(linkedRules.find(r => r.id === rule.id)), [linkedRules, rule.id]);
  const onLinkOrUnlinkRule = (0, _react.useCallback)(({
    target: {
      checked
    }
  }) => {
    const newLinkedRules = !checked ? linkedRules === null || linkedRules === void 0 ? void 0 : linkedRules.filter(item => item.id !== rule.id) : [...linkedRules, rule];
    if (typeof onRuleLinkChange === 'function') onRuleLinkChange(newLinkedRules);
  }, [linkedRules, onRuleLinkChange, rule]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    onChange: onLinkOrUnlinkRule,
    label: "",
    checked: isRuleLinked
  }));
});
exports.LinkRuleSwitch = LinkRuleSwitch;
LinkRuleSwitch.displayName = 'LinkRuleSwitch';