"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleIndexPattern = exports.useRuleForms = void 0;
var _react = require("react");
var _utils = require("../../../../common/detection_engine/utils");
var _types = require("../../../detections/pages/detection_engine/rules/types");
var _kibana = require("../../../common/lib/kibana");
var _shared_imports = require("../../../shared_imports");
var _schema = require("../../../detections/components/rules/step_define_rule/schema");
var _schema2 = require("../../../detections/components/rules/step_about_rule/schema");
var _schema3 = require("../../../detections/components/rules/step_schedule_rule/schema");
var _get_schema = require("../../../detections/components/rules/step_rule_actions/get_schema");
var _source = require("../../../common/containers/source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRuleForms = ({
  defineStepDefault,
  aboutStepDefault,
  scheduleStepDefault,
  actionsStepDefault
}) => {
  const {
    triggersActionsUi: {
      actionTypeRegistry
    }
  } = (0, _kibana.useKibana)().services;
  // DEFINE STEP FORM
  const {
    form: defineStepForm
  } = (0, _shared_imports.useForm)({
    defaultValue: defineStepDefault,
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema
  });
  const [eqlOptionsSelected, setEqlOptionsSelected] = (0, _react.useState)(defineStepDefault.eqlOptions);
  const [defineStepFormData] = (0, _shared_imports.useFormData)({
    form: defineStepForm
  });
  // FormData doesn't populate on the first render, so we use the defaultValue if the formData
  // doesn't have what we wanted
  const defineStepData = (0, _react.useMemo)(() => 'index' in defineStepFormData ? {
    ...defineStepFormData,
    eqlOptions: eqlOptionsSelected
  } : defineStepDefault, [defineStepDefault, defineStepFormData, eqlOptionsSelected]);

  // ABOUT STEP FORM
  const typeDependentAboutRuleSchema = (0, _react.useMemo)(() => (0, _utils.isThreatMatchRule)(defineStepData.ruleType) ? _schema2.threatMatchAboutSchema : _schema2.schema, [defineStepData.ruleType]);
  const {
    form: aboutStepForm
  } = (0, _shared_imports.useForm)({
    defaultValue: aboutStepDefault,
    options: {
      stripEmptyFields: false
    },
    schema: typeDependentAboutRuleSchema
  });
  const [aboutStepFormData] = (0, _shared_imports.useFormData)({
    form: aboutStepForm
  });
  const aboutStepData = 'name' in aboutStepFormData ? aboutStepFormData : aboutStepDefault;

  // SCHEDULE STEP FORM
  const {
    form: scheduleStepForm
  } = (0, _shared_imports.useForm)({
    defaultValue: scheduleStepDefault,
    options: {
      stripEmptyFields: false
    },
    schema: _schema3.schema
  });
  const [scheduleStepFormData] = (0, _shared_imports.useFormData)({
    form: scheduleStepForm
  });
  const scheduleStepData = 'interval' in scheduleStepFormData ? scheduleStepFormData : scheduleStepDefault;

  // ACTIONS STEP FORM
  const schema = (0, _react.useMemo)(() => (0, _get_schema.getSchema)({
    actionTypeRegistry
  }), [actionTypeRegistry]);
  const {
    form: actionsStepForm
  } = (0, _shared_imports.useForm)({
    defaultValue: actionsStepDefault,
    options: {
      stripEmptyFields: false
    },
    schema
  });
  const [actionsStepFormData] = (0, _shared_imports.useFormData)({
    form: actionsStepForm
  });
  const actionsStepData = 'actions' in actionsStepFormData ? actionsStepFormData : actionsStepDefault;
  return {
    defineStepForm,
    defineStepData,
    aboutStepForm,
    aboutStepData,
    scheduleStepForm,
    scheduleStepData,
    actionsStepForm,
    actionsStepData,
    eqlOptionsSelected,
    setEqlOptionsSelected
  };
};
exports.useRuleForms = useRuleForms;
const useRuleIndexPattern = ({
  dataSourceType,
  index,
  dataViewId
}) => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const [isIndexPatternLoading, {
    browserFields,
    indexPatterns: initIndexPattern
  }] = (0, _source.useFetchIndex)(index);
  const [indexPattern, setIndexPattern] = (0, _react.useState)(initIndexPattern);
  // Why do we need this? to ensure the query bar auto-suggest gets the latest updates
  // when the index pattern changes
  // when we select new dataView
  // when we choose some other dataSourceType
  (0, _react.useEffect)(() => {
    if (dataSourceType === _types.DataSourceType.IndexPatterns && !isIndexPatternLoading) {
      setIndexPattern(initIndexPattern);
    }
    if (dataSourceType === _types.DataSourceType.DataView) {
      const fetchDataView = async () => {
        if (dataViewId != null) {
          const dv = await data.dataViews.get(dataViewId);
          setIndexPattern(dv);
        }
      };
      fetchDataView();
    }
  }, [dataSourceType, isIndexPatternLoading, data, dataViewId, initIndexPattern]);
  return {
    indexPattern,
    isIndexPatternLoading,
    browserFields
  };
};
exports.useRuleIndexPattern = useRuleIndexPattern;