"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecurityDashboardsTableItems = exports.useSecurityDashboardsTableColumns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _links = require("../../common/components/links");
var _kibana = require("../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _telemetry = require("../../common/lib/telemetry");
var _constants = require("../../../common/constants");
var _link_to = require("../../common/components/link_to");
var _use_fetch_security_dashboards = require("../containers/use_fetch_security_dashboards");
var _empty_value = require("../../common/components/empty_value");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSecurityDashboardsTableItems = () => {
  const {
    dashboards,
    isLoading,
    error
  } = (0, _use_fetch_security_dashboards.useFetchSecurityDashboards)();
  const items = (0, _react.useMemo)(() => {
    if (!dashboards) {
      return [];
    }
    return dashboards.map(securityDashboard => {
      var _securityDashboard$at, _securityDashboard$at2, _securityDashboard$at3, _securityDashboard$at4;
      return {
        ...securityDashboard,
        title: (_securityDashboard$at = (_securityDashboard$at2 = securityDashboard.attributes.title) === null || _securityDashboard$at2 === void 0 ? void 0 : _securityDashboard$at2.toString()) !== null && _securityDashboard$at !== void 0 ? _securityDashboard$at : undefined,
        description: (_securityDashboard$at3 = (_securityDashboard$at4 = securityDashboard.attributes.description) === null || _securityDashboard$at4 === void 0 ? void 0 : _securityDashboard$at4.toString()) !== null && _securityDashboard$at3 !== void 0 ? _securityDashboard$at3 : undefined
      };
    });
  }, [dashboards]);
  return {
    items,
    isLoading,
    error
  };
};
exports.useSecurityDashboardsTableItems = useSecurityDashboardsTableItems;
const useSecurityDashboardsTableColumns = () => {
  const {
    savedObjectsTagging
  } = (0, _kibana.useKibana)().services;
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  const getSecuritySolutionUrl = (0, _link_to.useGetSecuritySolutionUrl)();
  const getNavigationHandler = (0, _react.useCallback)(href => ev => {
    ev.preventDefault();
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, _telemetry.TELEMETRY_EVENT.DASHBOARD);
    navigateTo({
      url: href
    });
  }, [navigateTo]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'title',
    name: i18n.DASHBOARD_TITLE,
    sortable: true,
    render: (title, {
      id
    }) => {
      const href = `${getSecuritySolutionUrl({
        deepLinkId: _constants.SecurityPageName.dashboards,
        path: id
      })}`;
      return href ? /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
        href: href,
        onClick: getNavigationHandler(href)
      }, title) : title;
    },
    'data-test-subj': 'dashboardTableTitleCell'
  }, {
    field: 'description',
    name: i18n.DASHBOARDS_DESCRIPTION,
    sortable: true,
    render: description => description || (0, _empty_value.getEmptyValue)(),
    'data-test-subj': 'dashboardTableDescriptionCell'
  },
  // adds the tags table column based on the saved object items
  ...(savedObjectsTagging ? [savedObjectsTagging.ui.getTableColumnDefinition()] : [])], [savedObjectsTagging, getSecuritySolutionUrl, getNavigationHandler]);
  return columns;
};
exports.useSecurityDashboardsTableColumns = useSecurityDashboardsTableColumns;