"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateSecurityDashboardLink = void 0;
var _react = require("react");
var _dashboard_context = require("../context/dashboard_context");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateSecurityDashboardLink = () => {
  const {
    dashboard
  } = (0, _kibana.useKibana)().services;
  const securityTags = (0, _dashboard_context.useSecurityTags)();
  const result = (0, _react.useMemo)(() => {
    var _securityTags$, _dashboard$locator$ge, _dashboard$locator;
    const firstSecurityTagId = securityTags === null || securityTags === void 0 ? void 0 : (_securityTags$ = securityTags[0]) === null || _securityTags$ === void 0 ? void 0 : _securityTags$.id;
    if (!firstSecurityTagId) {
      return {
        isLoading: true,
        url: ''
      };
    }
    return {
      isLoading: false,
      url: (_dashboard$locator$ge = dashboard === null || dashboard === void 0 ? void 0 : (_dashboard$locator = dashboard.locator) === null || _dashboard$locator === void 0 ? void 0 : _dashboard$locator.getRedirectUrl({
        tags: [firstSecurityTagId]
      })) !== null && _dashboard$locator$ge !== void 0 ? _dashboard$locator$ge : ''
    };
  }, [securityTags, dashboard === null || dashboard === void 0 ? void 0 : dashboard.locator]);
  return result;
};
exports.useCreateSecurityDashboardLink = useCreateSecurityDashboardLink;